/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus.proxy.internal.types.stream;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.nukleus.proxy.internal.types.ArrayFW;
import org.reaktivity.specification.nukleus.proxy.internal.types.Flyweight;

public final class WindowFW
extends Flyweight {
    public static final int FIELD_OFFSET_ROUTE_ID = 0;
    private static final int FIELD_SIZE_ROUTE_ID = 8;
    public static final int FIELD_OFFSET_STREAM_ID = 8;
    private static final int FIELD_SIZE_STREAM_ID = 8;
    public static final int FIELD_OFFSET_TIMESTAMP = 16;
    private static final int FIELD_SIZE_TIMESTAMP = 8;
    public static final int FIELD_OFFSET_TRACE_ID = 24;
    private static final int FIELD_SIZE_TRACE_ID = 8;
    public static final int FIELD_OFFSET_AUTHORIZATION = 32;
    private static final int FIELD_SIZE_AUTHORIZATION = 8;
    public static final int FIELD_OFFSET_BUDGET_ID = 40;
    private static final int FIELD_SIZE_BUDGET_ID = 8;
    public static final int FIELD_OFFSET_CREDIT = 48;
    private static final int FIELD_SIZE_CREDIT = 4;
    public static final int FIELD_OFFSET_PADDING = 52;
    private static final int FIELD_SIZE_PADDING = 4;
    public static final int FIELD_OFFSET_MINIMUM = 56;
    private static final int FIELD_SIZE_MINIMUM = 4;
    public static final int FIELD_OFFSET_CAPABILITIES = 60;
    private static final int FIELD_SIZE_CAPABILITIES = 1;
    public static final int TYPE_ID = 0x40000002;

    public long routeId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    public long streamId() {
        return this.buffer().getLong(this.offset() + 8);
    }

    public long timestamp() {
        return this.buffer().getLong(this.offset() + 16);
    }

    public long traceId() {
        return this.buffer().getLong(this.offset() + 24);
    }

    public long authorization() {
        return this.buffer().getLong(this.offset() + 32);
    }

    public long budgetId() {
        return this.buffer().getLong(this.offset() + 40);
    }

    public int credit() {
        return this.buffer().getInt(this.offset() + 48);
    }

    public int padding() {
        return this.buffer().getInt(this.offset() + 52);
    }

    public int minimum() {
        return this.buffer().getInt(this.offset() + 56);
    }

    public int capabilities() {
        return this.buffer().getByte(this.offset() + 60) & 0xFF;
    }

    public int typeId() {
        return 0x40000002;
    }

    @Override
    public WindowFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        WindowFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public WindowFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 60 + 1;
    }

    public String toString() {
        return String.format("WINDOW [routeId=%d, streamId=%d, timestamp=%d, traceId=%d, authorization=%d, budgetId=%d, credit=%d, padding=%d, minimum=%d, capabilities=%d]", this.routeId(), this.streamId(), this.timestamp(), this.traceId(), this.authorization(), this.budgetId(), this.credit(), this.padding(), this.minimum(), this.capabilities());
    }

    public static final class Builder
    extends Flyweight.Builder<WindowFW> {
        private static final int INDEX_ROUTE_ID = 0;
        private static final int INDEX_STREAM_ID = 1;
        private static final int INDEX_TIMESTAMP = 2;
        public static final long DEFAULT_TIMESTAMP = 0L;
        private static final int INDEX_TRACE_ID = 3;
        public static final long DEFAULT_TRACE_ID = 0L;
        private static final int INDEX_AUTHORIZATION = 4;
        public static final long DEFAULT_AUTHORIZATION = 0L;
        private static final int INDEX_BUDGET_ID = 5;
        private static final int INDEX_CREDIT = 6;
        private static final int INDEX_PADDING = 7;
        private static final int INDEX_MINIMUM = 8;
        public static final int DEFAULT_MINIMUM = 0;
        private static final int INDEX_CAPABILITIES = 9;
        public static final int DEFAULT_CAPABILITIES = 0;
        private static final int FIELD_COUNT = 10;
        private int lastFieldSet = -1;

        public Builder() {
            super(new WindowFW());
        }

        public Builder routeId(long value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 8;
            WindowFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder streamId(long value) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 8;
            WindowFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        public Builder timestamp(long value) {
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + 8;
            WindowFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 2;
            this.limit(newLimit);
            return this;
        }

        public Builder traceId(long value) {
            if (this.lastFieldSet < 2) {
                this.timestamp(0L);
            }
            assert (this.lastFieldSet == 2);
            int newLimit = this.limit() + 8;
            WindowFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 3;
            this.limit(newLimit);
            return this;
        }

        public Builder authorization(long value) {
            if (this.lastFieldSet < 3) {
                this.traceId(0L);
            }
            assert (this.lastFieldSet == 3);
            int newLimit = this.limit() + 8;
            WindowFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 4;
            this.limit(newLimit);
            return this;
        }

        public Builder budgetId(long value) {
            if (this.lastFieldSet < 4) {
                this.authorization(0L);
            }
            assert (this.lastFieldSet == 4);
            int newLimit = this.limit() + 8;
            WindowFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 5;
            this.limit(newLimit);
            return this;
        }

        public Builder credit(int value) {
            assert (this.lastFieldSet == 5);
            int newLimit = this.limit() + 4;
            WindowFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 6;
            this.limit(newLimit);
            return this;
        }

        public Builder padding(int value) {
            assert (this.lastFieldSet == 6);
            int newLimit = this.limit() + 4;
            WindowFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 7;
            this.limit(newLimit);
            return this;
        }

        public Builder minimum(int value) {
            assert (this.lastFieldSet == 7);
            int newLimit = this.limit() + 4;
            WindowFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 8;
            this.limit(newLimit);
            return this;
        }

        public Builder capabilities(int value) {
            if (value < 0) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"capabilities\"", value));
            }
            if (value > 255) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"capabilities\"", value));
            }
            if (this.lastFieldSet < 8) {
                this.minimum(0);
            }
            assert (this.lastFieldSet == 8);
            int newLimit = this.limit() + 1;
            WindowFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putByte(this.limit(), (byte)(value & 0xFF));
            this.lastFieldSet = 9;
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public WindowFW build() {
            if (this.lastFieldSet < 9) {
                this.capabilities(0);
            }
            assert (this.lastFieldSet == 9);
            this.lastFieldSet = -1;
            return (WindowFW)super.build();
        }
    }
}

