/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.sse.internal;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.kaazing.k3po.lang.el.Function;
import org.kaazing.k3po.lang.el.spi.FunctionMapperSpi;
import org.reaktivity.specification.sse.internal.types.control.SseRouteExFW;
import org.reaktivity.specification.sse.internal.types.stream.SseBeginExFW;
import org.reaktivity.specification.sse.internal.types.stream.SseDataExFW;
import org.reaktivity.specification.sse.internal.types.stream.SseEndExFW;

public final class SseFunctions {
    private static final ThreadLocal<DirectBuffer> DIRECT_BUFFER = ThreadLocal.withInitial(UnsafeBuffer::new);

    @Function
    public static SseRouteExBuilder routeEx() {
        return new SseRouteExBuilder();
    }

    @Function
    public static SseBeginExBuilder beginEx() {
        return new SseBeginExBuilder();
    }

    @Function
    public static SseDataExBuilder dataEx() {
        return new SseDataExBuilder();
    }

    @Function
    public static SseEndExBuilder endEx() {
        return new SseEndExBuilder();
    }

    private SseFunctions() {
    }

    public static class Mapper
    extends FunctionMapperSpi.Reflective {
        public Mapper() {
            super(SseFunctions.class);
        }

        public String getPrefixName() {
            return "sse";
        }
    }

    public static final class SseEndExBuilder {
        private final SseEndExFW.Builder endExRW;

        private SseEndExBuilder() {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[8192]);
            this.endExRW = new SseEndExFW.Builder().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity());
        }

        public SseEndExBuilder typeId(int typeId) {
            this.endExRW.typeId(typeId);
            return this;
        }

        public SseEndExBuilder id(String id) {
            this.endExRW.id(id);
            return this;
        }

        public byte[] build() {
            SseEndExFW endEx = this.endExRW.build();
            byte[] array = new byte[endEx.sizeof()];
            endEx.buffer().getBytes(endEx.offset(), array);
            return array;
        }
    }

    public static final class SseDataExBuilder {
        private final SseDataExFW.Builder dataExRW;

        private SseDataExBuilder() {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[8192]);
            this.dataExRW = new SseDataExFW.Builder().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity());
        }

        public SseDataExBuilder typeId(int typeId) {
            this.dataExRW.typeId(typeId);
            return this;
        }

        public SseDataExBuilder timestamp(long timestamp) {
            this.dataExRW.timestamp(timestamp);
            return this;
        }

        public SseDataExBuilder id(String id) {
            this.dataExRW.id(id);
            return this;
        }

        public SseDataExBuilder idAsRawBytes(byte[] id) {
            DirectBuffer buffer = (DirectBuffer)DIRECT_BUFFER.get();
            buffer.wrap(id);
            this.dataExRW.id(buffer, 0, buffer.capacity());
            return this;
        }

        public SseDataExBuilder type(String type) {
            this.dataExRW.type(type);
            return this;
        }

        public SseDataExBuilder typeAsRawBytes(byte[] type) {
            DirectBuffer buffer = (DirectBuffer)DIRECT_BUFFER.get();
            buffer.wrap(type);
            this.dataExRW.type(buffer, 0, buffer.capacity());
            return this;
        }

        public byte[] build() {
            SseDataExFW dataEx = this.dataExRW.build();
            byte[] array = new byte[dataEx.sizeof()];
            dataEx.buffer().getBytes(dataEx.offset(), array);
            return array;
        }
    }

    public static final class SseBeginExBuilder {
        private final SseBeginExFW.Builder beginExRW;

        private SseBeginExBuilder() {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[8192]);
            this.beginExRW = new SseBeginExFW.Builder().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity());
        }

        public SseBeginExBuilder typeId(int typeId) {
            this.beginExRW.typeId(typeId);
            return this;
        }

        public SseBeginExBuilder pathInfo(String pathInfo) {
            this.beginExRW.pathInfo(pathInfo);
            return this;
        }

        public SseBeginExBuilder lastEventId(String lastEventId) {
            this.beginExRW.lastEventId(lastEventId);
            return this;
        }

        public byte[] build() {
            SseBeginExFW beginEx = this.beginExRW.build();
            byte[] array = new byte[beginEx.sizeof()];
            beginEx.buffer().getBytes(beginEx.offset(), array);
            return array;
        }
    }

    public static final class SseRouteExBuilder {
        private final SseRouteExFW.Builder routeExRW;

        private SseRouteExBuilder() {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[8192]);
            this.routeExRW = new SseRouteExFW.Builder().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity());
        }

        public SseRouteExBuilder pathInfo(String pathInfo) {
            this.routeExRW.pathInfo(pathInfo);
            return this;
        }

        public byte[] build() {
            SseRouteExFW routeEx = this.routeExRW.build();
            byte[] array = new byte[routeEx.sizeof()];
            routeEx.buffer().getBytes(routeEx.offset(), array);
            return array;
        }
    }
}

