/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.sse.internal.types.stream;

import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.sse.internal.types.ArrayFW;
import org.reaktivity.specification.sse.internal.types.Flyweight;
import org.reaktivity.specification.sse.internal.types.String16FW;
import org.reaktivity.specification.sse.internal.types.String8FW;

public final class SseBeginExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_PATH_INFO = 4;
    public static final int FIELD_OFFSET_LAST_EVENT_ID = 0;
    private final String16FW pathInfoRO = new String16FW();
    private final String8FW lastEventIdRO = new String8FW();

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public String16FW pathInfo() {
        return this.pathInfoRO;
    }

    public String8FW lastEventId() {
        return this.lastEventIdRO;
    }

    @Override
    public SseBeginExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.pathInfoRO.wrap(buffer, offset + 4, maxLimit);
        this.lastEventIdRO.wrap(buffer, this.pathInfoRO.limit() + 0, maxLimit);
        SseBeginExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public SseBeginExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.pathInfoRO.tryWrap(buffer, offset + 4, maxLimit)) {
            return null;
        }
        if (null == this.lastEventIdRO.tryWrap(buffer, this.pathInfoRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.lastEventIdRO.limit();
    }

    public String toString() {
        return String.format("SSE_BEGIN_EX [typeId=%d, pathInfo=%s, lastEventId=%s]", this.typeId(), this.pathInfoRO.asString(), this.lastEventIdRO.asString());
    }

    public static final class Builder
    extends Flyweight.Builder<SseBeginExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private static final int INDEX_PATH_INFO = 1;
        private static final int INDEX_LAST_EVENT_ID = 2;
        private static final int FIELD_COUNT = 3;
        private final String16FW.Builder pathInfoRW = new String16FW.Builder();
        private final String8FW.Builder lastEventIdRW = new String8FW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new SseBeginExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            SseBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        private String16FW.Builder pathInfo() {
            assert (this.lastFieldSet == 0);
            return this.pathInfoRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder pathInfo(String value) {
            String16FW.Builder pathInfoRW = this.pathInfo();
            pathInfoRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 1;
            this.limit(pathInfoRW.build().limit());
            return this;
        }

        public Builder pathInfo(String16FW value) {
            String16FW.Builder pathInfoRW = this.pathInfo();
            pathInfoRW.set(value);
            this.lastFieldSet = 1;
            this.limit(pathInfoRW.build().limit());
            return this;
        }

        public Builder pathInfo(DirectBuffer buffer, int offset, int length) {
            String16FW.Builder pathInfoRW = this.pathInfo();
            pathInfoRW.set(buffer, offset, length);
            this.lastFieldSet = 1;
            this.limit(pathInfoRW.build().limit());
            return this;
        }

        private String8FW.Builder lastEventId() {
            assert (this.lastFieldSet == 1);
            return this.lastEventIdRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder lastEventId(String value) {
            String8FW.Builder lastEventIdRW = this.lastEventId();
            lastEventIdRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 2;
            this.limit(lastEventIdRW.build().limit());
            return this;
        }

        public Builder lastEventId(String8FW value) {
            String8FW.Builder lastEventIdRW = this.lastEventId();
            lastEventIdRW.set(value);
            this.lastFieldSet = 2;
            this.limit(lastEventIdRW.build().limit());
            return this;
        }

        public Builder lastEventId(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder lastEventIdRW = this.lastEventId();
            lastEventIdRW.set(buffer, offset, length);
            this.lastFieldSet = 2;
            this.limit(lastEventIdRW.build().limit());
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<SseBeginExFW>, ? extends Flyweight.Builder<SseBeginExFW>, SseBeginExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public SseBeginExFW build() {
            assert (this.lastFieldSet == 2);
            this.lastFieldSet = -1;
            return (SseBeginExFW)super.build();
        }
    }
}

