/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.sse.internal.types.stream;

import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.sse.internal.types.ArrayFW;
import org.reaktivity.specification.sse.internal.types.Flyweight;
import org.reaktivity.specification.sse.internal.types.String8FW;

public final class SseDataExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_TIMESTAMP = 4;
    private static final int FIELD_SIZE_TIMESTAMP = 8;
    public static final int FIELD_OFFSET_ID = 12;
    public static final int FIELD_OFFSET_TYPE = 0;
    private final String8FW idRO = new String8FW();
    private final String8FW typeRO = new String8FW();

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public long timestamp() {
        return this.buffer().getLong(this.offset() + 4);
    }

    public String8FW id() {
        return this.idRO;
    }

    public String8FW type() {
        return this.typeRO;
    }

    @Override
    public SseDataExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.idRO.wrap(buffer, offset + 12, maxLimit);
        this.typeRO.wrap(buffer, this.idRO.limit() + 0, maxLimit);
        SseDataExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public SseDataExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.idRO.tryWrap(buffer, offset + 12, maxLimit)) {
            return null;
        }
        if (null == this.typeRO.tryWrap(buffer, this.idRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.typeRO.limit();
    }

    public String toString() {
        return String.format("SSE_DATA_EX [typeId=%d, timestamp=%d, id=%s, type=%s]", this.typeId(), this.timestamp(), this.idRO.asString(), this.typeRO.asString());
    }

    public static final class Builder
    extends Flyweight.Builder<SseDataExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private static final int INDEX_TIMESTAMP = 1;
        private static final int INDEX_ID = 2;
        private static final int INDEX_TYPE = 3;
        private static final int FIELD_COUNT = 4;
        private final String8FW.Builder idRW = new String8FW.Builder();
        private final String8FW.Builder typeRW = new String8FW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new SseDataExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            SseDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder timestamp(long value) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 8;
            SseDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        private String8FW.Builder id() {
            assert (this.lastFieldSet == 1);
            return this.idRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder id(String value) {
            String8FW.Builder idRW = this.id();
            idRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 2;
            this.limit(idRW.build().limit());
            return this;
        }

        public Builder id(String8FW value) {
            String8FW.Builder idRW = this.id();
            idRW.set(value);
            this.lastFieldSet = 2;
            this.limit(idRW.build().limit());
            return this;
        }

        public Builder id(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder idRW = this.id();
            idRW.set(buffer, offset, length);
            this.lastFieldSet = 2;
            this.limit(idRW.build().limit());
            return this;
        }

        private String8FW.Builder type() {
            assert (this.lastFieldSet == 2);
            return this.typeRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder type(String value) {
            String8FW.Builder typeRW = this.type();
            typeRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 3;
            this.limit(typeRW.build().limit());
            return this;
        }

        public Builder type(String8FW value) {
            String8FW.Builder typeRW = this.type();
            typeRW.set(value);
            this.lastFieldSet = 3;
            this.limit(typeRW.build().limit());
            return this;
        }

        public Builder type(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder typeRW = this.type();
            typeRW.set(buffer, offset, length);
            this.lastFieldSet = 3;
            this.limit(typeRW.build().limit());
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<SseDataExFW>, ? extends Flyweight.Builder<SseDataExFW>, SseDataExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public SseDataExFW build() {
            assert (this.lastFieldSet == 3);
            this.lastFieldSet = -1;
            return (SseDataExFW)super.build();
        }
    }
}

