/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.sse.internal.types.stream;

import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.sse.internal.types.ArrayFW;
import org.reaktivity.specification.sse.internal.types.Flyweight;
import org.reaktivity.specification.sse.internal.types.String8FW;

public final class SseEndExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_ID = 4;
    private final String8FW idRO = new String8FW();

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public String8FW id() {
        return this.idRO;
    }

    @Override
    public SseEndExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.idRO.wrap(buffer, offset + 4, maxLimit);
        SseEndExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public SseEndExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.idRO.tryWrap(buffer, offset + 4, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.idRO.limit();
    }

    public String toString() {
        return String.format("SSE_END_EX [typeId=%d, id=%s]", this.typeId(), this.idRO.asString());
    }

    public static final class Builder
    extends Flyweight.Builder<SseEndExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private static final int INDEX_ID = 1;
        private static final int FIELD_COUNT = 2;
        private final String8FW.Builder idRW = new String8FW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new SseEndExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            SseEndExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        private String8FW.Builder id() {
            assert (this.lastFieldSet == 0);
            return this.idRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder id(String value) {
            String8FW.Builder idRW = this.id();
            idRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 1;
            this.limit(idRW.build().limit());
            return this;
        }

        public Builder id(String8FW value) {
            String8FW.Builder idRW = this.id();
            idRW.set(value);
            this.lastFieldSet = 1;
            this.limit(idRW.build().limit());
            return this;
        }

        public Builder id(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder idRW = this.id();
            idRW.set(buffer, offset, length);
            this.lastFieldSet = 1;
            this.limit(idRW.build().limit());
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<SseEndExFW>, ? extends Flyweight.Builder<SseEndExFW>, SseEndExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public SseEndExFW build() {
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (SseEndExFW)super.build();
        }
    }
}

