/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.tcp.internal;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.function.Consumer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.kaazing.k3po.lang.el.Function;
import org.kaazing.k3po.lang.el.spi.FunctionMapperSpi;
import org.reaktivity.specification.tcp.internal.types.TcpAddressFW;
import org.reaktivity.specification.tcp.internal.types.stream.TcpBeginExFW;

public final class TcpFunctions {
    @Function
    public static TcpBeginExBuilder beginEx() {
        return new TcpBeginExBuilder();
    }

    private TcpFunctions() {
    }

    public static class Mapper
    extends FunctionMapperSpi.Reflective {
        public Mapper() {
            super(TcpFunctions.class);
        }

        public String getPrefixName() {
            return "tcp";
        }
    }

    public static final class TcpBeginExBuilder {
        private final TcpBeginExFW.Builder beginExRW;

        private TcpBeginExBuilder() {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[1024]);
            this.beginExRW = new TcpBeginExFW.Builder().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity());
        }

        public TcpBeginExBuilder typeId(int type) {
            this.beginExRW.typeId(type);
            return this;
        }

        public TcpBeginExBuilder localAddress(String localAddress) throws UnknownHostException {
            InetAddress inet = InetAddress.getByName(localAddress);
            byte[] ip = inet.getAddress();
            Consumer<TcpAddressFW.Builder> addressBuilder = inet instanceof Inet4Address ? b -> b.ipv4Address(s -> s.put(ip)) : b -> b.ipv6Address(s -> s.put(ip));
            this.beginExRW.localAddress(addressBuilder);
            return this;
        }

        public TcpBeginExBuilder localPort(int localPort) {
            this.beginExRW.localPort(localPort);
            return this;
        }

        public TcpBeginExBuilder remoteAddress(String remoteAddress) throws UnknownHostException {
            InetAddress inet = InetAddress.getByName(remoteAddress);
            byte[] ip = inet.getAddress();
            Consumer<TcpAddressFW.Builder> addressBuilder = inet instanceof Inet4Address ? b -> b.ipv4Address(s -> s.put(ip)) : b -> b.ipv6Address(s -> s.put(ip));
            this.beginExRW.remoteAddress(addressBuilder);
            return this;
        }

        public TcpBeginExBuilder remoteHost(String remoteHost) {
            this.beginExRW.remoteAddress((TcpAddressFW.Builder b) -> b.host(remoteHost));
            return this;
        }

        public TcpBeginExBuilder remotePort(int remotePort) {
            this.beginExRW.remotePort(remotePort);
            return this;
        }

        public byte[] build() {
            TcpBeginExFW beginEx = this.beginExRW.build();
            byte[] array = new byte[beginEx.sizeof()];
            beginEx.buffer().getBytes(0, array);
            return array;
        }
    }
}

