/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.tcp.internal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.CompletableFuture;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.nukleus.Controller;
import org.reaktivity.nukleus.ControllerSpi;
import org.reaktivity.nukleus.route.RouteKind;
import org.reaktivity.nukleus.tcp.internal.types.Flyweight;
import org.reaktivity.nukleus.tcp.internal.types.OctetsFW;
import org.reaktivity.nukleus.tcp.internal.types.control.FreezeFW;
import org.reaktivity.nukleus.tcp.internal.types.control.Role;
import org.reaktivity.nukleus.tcp.internal.types.control.RouteFW;
import org.reaktivity.nukleus.tcp.internal.types.control.UnrouteFW;

public final class TcpController
implements Controller {
    private static final int MAX_SEND_LENGTH = 1024;
    private final RouteFW.Builder routeRW = new RouteFW.Builder();
    private final UnrouteFW.Builder unrouteRW = new UnrouteFW.Builder();
    private final FreezeFW.Builder freezeRW = new FreezeFW.Builder();
    private final OctetsFW extensionRO = new OctetsFW().wrap((DirectBuffer)new UnsafeBuffer(new byte[0]), 0, 0);
    private final ControllerSpi controllerSpi;
    private final AtomicBuffer commandBuffer;

    public TcpController(ControllerSpi controllerSpi) {
        this.controllerSpi = controllerSpi;
        this.commandBuffer = new UnsafeBuffer(ByteBuffer.allocateDirect(1024).order(ByteOrder.nativeOrder()));
    }

    public int process() {
        return this.controllerSpi.doProcess();
    }

    public void close() throws Exception {
        this.controllerSpi.doClose();
    }

    public Class<TcpController> kind() {
        return TcpController.class;
    }

    public String name() {
        return "tcp";
    }

    @Deprecated
    public CompletableFuture<Long> routeServer(String localAddress, String remoteAddress) {
        return this.route(RouteKind.SERVER, localAddress, remoteAddress);
    }

    @Deprecated
    public CompletableFuture<Long> routeClient(String localAddress, String remoteAddress) {
        return this.route(RouteKind.CLIENT, localAddress, remoteAddress);
    }

    public CompletableFuture<Long> route(RouteKind kind, String localAddress, String remoteAddress) {
        return this.route(kind, localAddress, remoteAddress, null);
    }

    public CompletableFuture<Long> route(RouteKind kind, String localAddress, String remoteAddress, String extension) {
        return this.doRoute(kind, localAddress, remoteAddress, this.extensionRO);
    }

    public CompletableFuture<Void> unroute(long routeId) {
        long correlationId = this.controllerSpi.nextCorrelationId();
        UnrouteFW unrouteRO = this.unrouteRW.wrap((MutableDirectBuffer)this.commandBuffer, 0, this.commandBuffer.capacity()).correlationId(correlationId).nukleus(this.name()).routeId(routeId).build();
        return this.controllerSpi.doUnroute(unrouteRO.typeId(), unrouteRO.buffer(), unrouteRO.offset(), unrouteRO.sizeof());
    }

    public CompletableFuture<Void> freeze() {
        long correlationId = this.controllerSpi.nextCorrelationId();
        FreezeFW freeze = this.freezeRW.wrap((MutableDirectBuffer)this.commandBuffer, 0, this.commandBuffer.capacity()).correlationId(correlationId).nukleus(this.name()).build();
        return this.controllerSpi.doFreeze(freeze.typeId(), freeze.buffer(), freeze.offset(), freeze.sizeof());
    }

    private CompletableFuture<Long> doRoute(RouteKind kind, String localAddress, String remoteAddress, Flyweight extension) {
        long correlationId = this.controllerSpi.nextCorrelationId();
        Role role = Role.valueOf(kind.ordinal());
        RouteFW routeRO = this.routeRW.wrap((MutableDirectBuffer)this.commandBuffer, 0, this.commandBuffer.capacity()).correlationId(correlationId).nukleus(this.name()).role(b -> b.set(role)).localAddress(localAddress).remoteAddress(remoteAddress).extension(extension.buffer(), extension.offset(), extension.sizeof()).build();
        return this.controllerSpi.doRoute(routeRO.typeId(), routeRO.buffer(), routeRO.offset(), routeRO.sizeof());
    }
}

