/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.tcp.internal;

import java.util.HashMap;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.collections.Long2ObjectHashMap;
import org.reaktivity.nukleus.Elektron;
import org.reaktivity.nukleus.route.AddressFactoryBuilder;
import org.reaktivity.nukleus.route.RouteKind;
import org.reaktivity.nukleus.stream.StreamFactoryBuilder;
import org.reaktivity.nukleus.tcp.internal.TcpConfiguration;
import org.reaktivity.nukleus.tcp.internal.TcpRouteCounters;
import org.reaktivity.nukleus.tcp.internal.poller.Poller;
import org.reaktivity.nukleus.tcp.internal.stream.Acceptor;
import org.reaktivity.nukleus.tcp.internal.stream.TcpAddressFactoryBuilder;
import org.reaktivity.nukleus.tcp.internal.stream.TcpClientFactoryBuilder;
import org.reaktivity.nukleus.tcp.internal.stream.TcpServerFactoryBuilder;
import org.reaktivity.nukleus.tcp.internal.types.control.UnrouteFW;

final class TcpElektron
implements Elektron {
    private final UnrouteFW unrouteRO = new UnrouteFW();
    private final Acceptor acceptor;
    private final Poller poller;
    private final Long2ObjectHashMap<TcpRouteCounters> countersByRouteId;
    private final Map<RouteKind, StreamFactoryBuilder> streamFactoryBuilders;
    private final Map<RouteKind, AddressFactoryBuilder> addressFactoryBuilders;

    TcpElektron(TcpConfiguration config) {
        Acceptor acceptor = new Acceptor(config);
        Poller poller = new Poller();
        acceptor.setPoller(poller);
        Long2ObjectHashMap countersByRouteId = new Long2ObjectHashMap();
        HashMap<RouteKind, StreamFactoryBuilder> streamFactoryBuilders = new HashMap<RouteKind, StreamFactoryBuilder>();
        streamFactoryBuilders.put(RouteKind.SERVER, new TcpServerFactoryBuilder(config, (Long2ObjectHashMap<TcpRouteCounters>)countersByRouteId, acceptor, poller));
        streamFactoryBuilders.put(RouteKind.CLIENT, new TcpClientFactoryBuilder(config, (Long2ObjectHashMap<TcpRouteCounters>)countersByRouteId, poller));
        HashMap<RouteKind, AddressFactoryBuilder> addressFactoryBuilders = new HashMap<RouteKind, AddressFactoryBuilder>();
        addressFactoryBuilders.put(RouteKind.SERVER, new TcpAddressFactoryBuilder(this::handleServerRouted));
        addressFactoryBuilders.put(RouteKind.CLIENT, new TcpAddressFactoryBuilder(this::handleRouted));
        this.acceptor = acceptor;
        this.poller = poller;
        this.streamFactoryBuilders = streamFactoryBuilders;
        this.addressFactoryBuilders = addressFactoryBuilders;
        this.countersByRouteId = countersByRouteId;
    }

    public StreamFactoryBuilder streamFactoryBuilder(RouteKind kind) {
        return this.streamFactoryBuilders.get(kind);
    }

    public AddressFactoryBuilder addressFactoryBuilder(RouteKind kind) {
        return this.addressFactoryBuilders.get(kind);
    }

    public Poller agent() {
        return this.poller;
    }

    public String toString() {
        return String.format("%s %s", this.getClass().getSimpleName(), this.streamFactoryBuilders);
    }

    private void handleServerRouted(int msgTypeId, DirectBuffer buffer, int index, int length) {
        this.acceptor.handleRouted(msgTypeId, buffer, index, length);
        this.handleRouted(msgTypeId, buffer, index, length);
    }

    private void handleRouted(int msgTypeId, DirectBuffer buffer, int index, int length) {
        switch (msgTypeId) {
            case 2: {
                UnrouteFW unroute = this.unrouteRO.wrap(buffer, index, index + length);
                long routeId = unroute.routeId();
                this.countersByRouteId.remove(routeId);
            }
        }
    }
}

