/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.tcp.internal.stream;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.util.Objects;
import java.util.function.LongFunction;
import java.util.function.LongSupplier;
import java.util.function.LongUnaryOperator;
import java.util.function.ToIntFunction;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.nukleus.buffer.BufferPool;
import org.reaktivity.nukleus.function.MessageConsumer;
import org.reaktivity.nukleus.function.MessageFunction;
import org.reaktivity.nukleus.function.MessagePredicate;
import org.reaktivity.nukleus.route.RouteManager;
import org.reaktivity.nukleus.stream.StreamFactory;
import org.reaktivity.nukleus.tcp.internal.TcpConfiguration;
import org.reaktivity.nukleus.tcp.internal.TcpCounters;
import org.reaktivity.nukleus.tcp.internal.TcpRouteCounters;
import org.reaktivity.nukleus.tcp.internal.poller.Poller;
import org.reaktivity.nukleus.tcp.internal.poller.PollerKey;
import org.reaktivity.nukleus.tcp.internal.stream.TcpState;
import org.reaktivity.nukleus.tcp.internal.types.Flyweight;
import org.reaktivity.nukleus.tcp.internal.types.OctetsFW;
import org.reaktivity.nukleus.tcp.internal.types.control.RouteFW;
import org.reaktivity.nukleus.tcp.internal.types.stream.AbortFW;
import org.reaktivity.nukleus.tcp.internal.types.stream.BeginFW;
import org.reaktivity.nukleus.tcp.internal.types.stream.DataFW;
import org.reaktivity.nukleus.tcp.internal.types.stream.EndFW;
import org.reaktivity.nukleus.tcp.internal.types.stream.ResetFW;
import org.reaktivity.nukleus.tcp.internal.types.stream.TcpBeginExFW;
import org.reaktivity.nukleus.tcp.internal.types.stream.WindowFW;
import org.reaktivity.nukleus.tcp.internal.util.IpUtil;

public class TcpServerFactory
implements StreamFactory {
    private final RouteFW routeRO = new RouteFW();
    private final BeginFW beginRO = new BeginFW();
    private final DataFW dataRO = new DataFW();
    private final EndFW endRO = new EndFW();
    private final AbortFW abortRO = new AbortFW();
    private final ResetFW resetRO = new ResetFW();
    private final WindowFW windowRO = new WindowFW();
    private final BeginFW.Builder beginRW = new BeginFW.Builder();
    private final DataFW.Builder dataRW = new DataFW.Builder();
    private final EndFW.Builder endRW = new EndFW.Builder();
    private final AbortFW.Builder abortRW = new AbortFW.Builder();
    private final ResetFW.Builder resetRW = new ResetFW.Builder();
    private final WindowFW.Builder windowRW = new WindowFW.Builder();
    private final TcpBeginExFW.Builder beginExRW = new TcpBeginExFW.Builder();
    private final MessageFunction<RouteFW> wrapRoute = (t, b, i, l) -> this.routeRO.wrap(b, i, i + l);
    private final RouteManager router;
    private final LongUnaryOperator supplyInitialId;
    private final LongUnaryOperator supplyReplyId;
    private final LongSupplier supplyTraceId;
    private final Long2ObjectHashMap<TcpServer> correlations;
    private final Poller poller;
    private final Runnable onNetworkClosed;
    private final BufferPool bufferPool;
    private final ByteBuffer readByteBuffer;
    private final MutableDirectBuffer readBuffer;
    private final MutableDirectBuffer writeBuffer;
    private final ByteBuffer writeByteBuffer;
    private final int windowThreshold;
    private final int tcpTypeId;
    final TcpCounters counters;

    public TcpServerFactory(TcpConfiguration config, RouteManager router, MutableDirectBuffer writeBuffer, BufferPool bufferPool, LongUnaryOperator supplyInitialId, LongSupplier supplyTraceId, ToIntFunction<String> supplyTypeId, LongUnaryOperator supplyReplyId, Poller poller, TcpCounters counters, Runnable onChannelClosed) {
        this.router = Objects.requireNonNull(router);
        this.writeBuffer = Objects.requireNonNull(writeBuffer);
        this.writeByteBuffer = ByteBuffer.allocateDirect(writeBuffer.capacity()).order(ByteOrder.nativeOrder());
        this.bufferPool = Objects.requireNonNull(bufferPool);
        this.supplyInitialId = Objects.requireNonNull(supplyInitialId);
        this.supplyReplyId = Objects.requireNonNull(supplyReplyId);
        this.supplyTraceId = Objects.requireNonNull(supplyTraceId);
        this.poller = Objects.requireNonNull(poller);
        this.counters = Objects.requireNonNull(counters);
        this.onNetworkClosed = Objects.requireNonNull(onChannelClosed);
        this.tcpTypeId = supplyTypeId.applyAsInt("tcp");
        int readBufferSize = writeBuffer.capacity() - 57;
        this.readByteBuffer = ByteBuffer.allocateDirect(readBufferSize).order(ByteOrder.nativeOrder());
        this.readBuffer = new UnsafeBuffer(this.readByteBuffer);
        this.windowThreshold = bufferPool.slotCapacity() * config.windowThreshold() / 100;
        this.correlations = new Long2ObjectHashMap();
    }

    public MessageConsumer newStream(int msgTypeId, DirectBuffer buffer, int index, int length, MessageConsumer throttle) {
        BeginFW begin = this.beginRO.wrap(buffer, index, index + length);
        long streamId = begin.streamId();
        MessageConsumer newStream = null;
        if ((streamId & 1L) == 0L) {
            newStream = this.newReplyStream(begin, throttle);
        }
        return newStream;
    }

    void onAccepted(SocketChannel network, InetSocketAddress address, LongFunction<InetSocketAddress> lookupAddress) {
        MessagePredicate filter = (t, b, i, l) -> {
            RouteFW route = (RouteFW)this.wrapRoute.apply(t, b, i, l);
            long routeId = route.correlationId();
            InetSocketAddress routedAddress = (InetSocketAddress)lookupAddress.apply(routeId);
            return IpUtil.compareAddresses(address, routedAddress) == 0;
        };
        RouteFW route = (RouteFW)this.router.resolveExternal(0L, filter, this.wrapRoute);
        if (route != null) {
            long routeId = route.correlationId();
            TcpServer server = new TcpServer(routeId, network);
            this.correlations.put(server.replyId, (Object)server);
            server.onNetworkAccepted();
        } else {
            this.doCloseNetwork(network);
        }
    }

    private MessageConsumer newReplyStream(BeginFW begin, MessageConsumer throttle) {
        long replyId = begin.streamId();
        TcpServer server = (TcpServer)this.correlations.remove(replyId);
        MessageConsumer newStream = null;
        if (server != null) {
            newStream = (x$0, x$1, x$2, x$3) -> server.onApplication(x$0, x$1, x$2, x$3);
        }
        return newStream;
    }

    private void doCloseNetwork(SocketChannel network) {
        CloseHelper.quietClose((AutoCloseable)network);
        this.onNetworkClosed.run();
    }

    private void doBegin(MessageConsumer receiver, long routeId, long streamId, long traceId, InetSocketAddress localAddress, InetSocketAddress remoteAddress) {
        BeginFW begin = this.beginRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).traceId(traceId).affinity(streamId).extension(b -> b.set(this.tcpBeginEx(localAddress, remoteAddress))).build();
        receiver.accept(begin.typeId(), begin.buffer(), begin.offset(), begin.sizeof());
    }

    private void doData(MessageConsumer stream, long routeId, long streamId, long traceId, long budgetId, int reserved, DirectBuffer payload, int offset, int length) {
        DataFW data = this.dataRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).traceId(traceId).budgetId(budgetId).reserved(reserved).payload(payload, offset, length).build();
        stream.accept(data.typeId(), data.buffer(), data.offset(), data.sizeof());
    }

    private void doEnd(MessageConsumer receiver, long routeId, long streamId, long traceId) {
        EndFW end = this.endRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).traceId(traceId).build();
        receiver.accept(end.typeId(), end.buffer(), end.offset(), end.sizeof());
    }

    private void doAbort(MessageConsumer receiver, long routeId, long streamId, long traceId) {
        AbortFW abort = this.abortRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).traceId(traceId).build();
        receiver.accept(abort.typeId(), abort.buffer(), abort.offset(), abort.sizeof());
    }

    private void doReset(MessageConsumer receiver, long routeId, long streamId, long traceId) {
        ResetFW reset = this.resetRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).traceId(traceId).build();
        receiver.accept(reset.typeId(), reset.buffer(), reset.offset(), reset.sizeof());
    }

    private void doWindow(MessageConsumer sender, long routeId, long streamId, long traceId, int budgetId, int credit, int padding) {
        WindowFW window = this.windowRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).traceId(traceId).budgetId(budgetId).credit(credit).padding(padding).build();
        sender.accept(window.typeId(), window.buffer(), window.offset(), window.sizeof());
    }

    private Flyweight.Builder.Visitor tcpBeginEx(InetSocketAddress localAddress, InetSocketAddress remoteAddress) {
        return (buffer, offset, limit) -> this.beginExRW.wrap(buffer, offset, limit).typeId(this.tcpTypeId).localAddress(a -> IpUtil.socketAddress(localAddress, a::ipv4Address, a::ipv6Address)).localPort(localAddress.getPort()).remoteAddress(a -> IpUtil.socketAddress(remoteAddress, a::ipv4Address, a::ipv6Address)).remotePort(remoteAddress.getPort()).build().sizeof();
    }

    private final class TcpServer {
        private final long routeId;
        private final long initialId;
        private final long replyId;
        private final MessageConsumer application;
        private final SocketChannel network;
        private final PollerKey networkKey;
        private final TcpRouteCounters counters;
        private long initialBudgetId;
        private int initialBudget;
        private int initialPadding;
        private int replyBudget;
        private int state;
        private int networkSlot = -1;
        private int networkSlotOffset;
        private int bytesFlushed;

        private TcpServer(long routeId, SocketChannel network) {
            this.routeId = routeId;
            this.initialId = TcpServerFactory.this.supplyInitialId.applyAsLong(routeId);
            this.replyId = TcpServerFactory.this.supplyReplyId.applyAsLong(this.initialId);
            this.application = TcpServerFactory.this.router.supplyReceiver(this.initialId);
            this.network = network;
            this.networkKey = TcpServerFactory.this.poller.doRegister(network, 0, null);
            this.counters = TcpServerFactory.this.counters.supplyRoute(routeId);
        }

        private void onNetworkAccepted() {
            try {
                this.networkKey.handler(1, this::onNetworkReadable);
                this.networkKey.handler(4, this::onNetworkWritable);
                this.doApplicationBegin();
            }
            catch (IOException ex) {
                this.doCleanup(TcpServerFactory.this.supplyTraceId.getAsLong());
            }
        }

        private int onNetworkReadable(PollerKey key) {
            assert (this.initialBudget > this.initialPadding);
            int limit = Math.min(this.initialBudget - this.initialPadding, TcpServerFactory.this.readBuffer.capacity());
            ((Buffer)TcpServerFactory.this.readByteBuffer).position(0);
            ((Buffer)TcpServerFactory.this.readByteBuffer).limit(limit);
            try {
                int bytesRead = this.network.read(TcpServerFactory.this.readByteBuffer);
                if (bytesRead == -1) {
                    key.clear(1);
                    CloseHelper.close(this.network::shutdownInput);
                    this.doApplicationEnd(TcpServerFactory.this.supplyTraceId.getAsLong());
                    if (this.network.socket().isOutputShutdown()) {
                        TcpServerFactory.this.doCloseNetwork(this.network);
                    }
                } else if (bytesRead != 0) {
                    this.doApplicationData((DirectBuffer)TcpServerFactory.this.readBuffer, 0, bytesRead);
                }
            }
            catch (IOException ex) {
                this.doCleanup(TcpServerFactory.this.supplyTraceId.getAsLong());
            }
            return 1;
        }

        private int onNetworkWritable(PollerKey key) {
            if (this.networkSlot == -1) {
                this.counters.writeopsNoSlot.getAsLong();
                assert (key == this.networkKey);
                return 0;
            }
            assert (this.networkSlot != -1);
            long traceId = TcpServerFactory.this.supplyTraceId.getAsLong();
            MutableDirectBuffer buffer = TcpServerFactory.this.bufferPool.buffer(this.networkSlot);
            ByteBuffer byteBuffer = TcpServerFactory.this.bufferPool.byteBuffer(this.networkSlot);
            byteBuffer.limit(byteBuffer.position() + this.networkSlotOffset);
            return this.doNetworkWrite((DirectBuffer)buffer, 0, this.networkSlotOffset, byteBuffer, traceId);
        }

        private int doNetworkWrite(DirectBuffer buffer, int offset, int length, ByteBuffer byteBuffer, long traceId) {
            int bytesWritten = 0;
            try {
                for (int i = 16; bytesWritten == 0 && i > 0; --i) {
                    bytesWritten = this.network.write(byteBuffer);
                }
                this.bytesFlushed += bytesWritten;
                if (bytesWritten < length) {
                    if (this.networkSlot == -1) {
                        this.networkSlot = TcpServerFactory.this.bufferPool.acquire(this.replyId);
                    }
                    if (this.networkSlot == -1) {
                        this.counters.overflows.getAsLong();
                        this.doApplicationResetIfNecessary(traceId);
                        this.doCleanup(traceId);
                    } else {
                        MutableDirectBuffer slotBuffer = TcpServerFactory.this.bufferPool.buffer(this.networkSlot);
                        slotBuffer.putBytes(0, buffer, offset + bytesWritten, length - bytesWritten);
                        this.networkSlotOffset = length - bytesWritten;
                        this.networkKey.register(4);
                        this.counters.writeops.getAsLong();
                    }
                } else {
                    this.cleanupNetworkSlotIfNecessary();
                    this.networkKey.clear(4);
                    if (TcpState.replyClosing(this.state)) {
                        this.doNetworkShutdownOutput(traceId);
                    } else if (this.bytesFlushed >= TcpServerFactory.this.windowThreshold) {
                        this.doApplicationWindow(traceId, this.bytesFlushed);
                        this.bytesFlushed = 0;
                    }
                }
            }
            catch (IOException ex) {
                this.doCleanup(traceId);
            }
            return bytesWritten;
        }

        private void doNetworkShutdownOutput(long traceId) {
            this.cleanupNetworkSlotIfNecessary();
            try {
                this.networkKey.clear(4);
                this.network.shutdownOutput();
                this.state = TcpState.closeReply(this.state);
                if (this.network.socket().isInputShutdown()) {
                    TcpServerFactory.this.doCloseNetwork(this.network);
                }
            }
            catch (IOException ex) {
                this.doCleanup(traceId);
            }
        }

        private void onApplication(int msgTypeId, DirectBuffer buffer, int index, int length) {
            switch (msgTypeId) {
                case 1: {
                    BeginFW begin = TcpServerFactory.this.beginRO.wrap(buffer, index, index + length);
                    this.onApplicationBegin(begin);
                    break;
                }
                case 2: {
                    DataFW data = TcpServerFactory.this.dataRO.wrap(buffer, index, index + length);
                    this.onApplicationData(data);
                    break;
                }
                case 3: {
                    EndFW end = TcpServerFactory.this.endRO.wrap(buffer, index, index + length);
                    this.onApplicationEnd(end);
                    break;
                }
                case 4: {
                    AbortFW abort = TcpServerFactory.this.abortRO.wrap(buffer, index, index + length);
                    this.onApplicationAbort(abort);
                    break;
                }
                case 0x40000001: {
                    ResetFW reset = TcpServerFactory.this.resetRO.wrap(buffer, index, index + length);
                    this.onApplicationReset(reset);
                    break;
                }
                case 0x40000002: {
                    WindowFW window = TcpServerFactory.this.windowRO.wrap(buffer, index, index + length);
                    this.onApplicationWindow(window);
                }
            }
        }

        private void onApplicationBegin(BeginFW begin) {
            long traceId = begin.traceId();
            int credit = TcpServerFactory.this.bufferPool.slotCapacity();
            this.state = TcpState.openReply(this.state);
            this.counters.opensRead.getAsLong();
            this.doApplicationWindow(traceId, credit);
        }

        private void onApplicationData(DataFW data) {
            long traceId = data.traceId();
            int reserved = data.reserved();
            this.replyBudget -= reserved;
            if (this.replyBudget < 0) {
                this.doApplicationReset(traceId);
                this.doCleanup(traceId, true);
            } else {
                ByteBuffer byteBuffer;
                OctetsFW payload = data.payload();
                DirectBuffer buffer = payload.buffer();
                int offset = payload.offset();
                int length = payload.sizeof();
                assert (reserved == length);
                assert (length > 0);
                if (this.networkSlot != -1) {
                    MutableDirectBuffer slotBuffer = TcpServerFactory.this.bufferPool.buffer(this.networkSlot);
                    slotBuffer.putBytes(this.networkSlotOffset, buffer, offset, length);
                    this.networkSlotOffset += length;
                    ByteBuffer slotByteBuffer = TcpServerFactory.this.bufferPool.byteBuffer(this.networkSlot);
                    slotByteBuffer.limit(slotByteBuffer.position() + this.networkSlotOffset);
                    buffer = slotBuffer;
                    offset = 0;
                    length = this.networkSlotOffset;
                    byteBuffer = slotByteBuffer;
                } else {
                    TcpServerFactory.this.writeByteBuffer.clear();
                    buffer.getBytes(offset, TcpServerFactory.this.writeByteBuffer, length);
                    TcpServerFactory.this.writeByteBuffer.flip();
                    byteBuffer = TcpServerFactory.this.writeByteBuffer;
                }
                this.doNetworkWrite(buffer, offset, length, byteBuffer, traceId);
            }
        }

        private void onApplicationEnd(EndFW end) {
            long traceId = end.traceId();
            this.state = TcpState.closingReply(this.state);
            if (this.networkSlot == -1) {
                this.doNetworkShutdownOutput(traceId);
            }
        }

        private void onApplicationAbort(AbortFW abort) {
            long traceId = abort.traceId();
            this.doNetworkShutdownOutput(traceId);
        }

        private void onApplicationReset(ResetFW reset) {
            this.state = TcpState.closeInitial(this.state);
            CloseHelper.quietClose(this.network::shutdownInput);
            boolean abortiveRelease = TcpServerFactory.this.correlations.containsKey(this.replyId);
            long traceId = reset.traceId();
            this.doCleanup(traceId, abortiveRelease);
        }

        private void onApplicationWindow(WindowFW window) {
            long budgetId = window.budgetId();
            int credit = window.credit();
            int padding = window.padding();
            this.initialBudgetId = budgetId;
            this.initialBudget += credit;
            this.initialPadding = padding;
            this.state = TcpState.openInitial(this.state);
            if (this.initialBudget > this.initialPadding) {
                this.onNetworkReadable(this.networkKey);
            } else {
                this.networkKey.clear(1);
            }
            if (this.initialBudget > this.initialPadding && !TcpState.initialClosed(this.state)) {
                this.networkKey.register(1);
                this.counters.readops.getAsLong();
            }
        }

        private void doApplicationBegin() throws IOException {
            long traceId = TcpServerFactory.this.supplyTraceId.getAsLong();
            InetSocketAddress localAddress = (InetSocketAddress)this.network.getLocalAddress();
            InetSocketAddress remoteAddress = (InetSocketAddress)this.network.getRemoteAddress();
            TcpServerFactory.this.router.setThrottle(this.initialId, this::onApplication);
            TcpServerFactory.this.doBegin(this.application, this.routeId, this.initialId, traceId, localAddress, remoteAddress);
            this.counters.opensWritten.getAsLong();
            this.state = TcpState.openingInitial(this.state);
        }

        private void doApplicationData(DirectBuffer buffer, int offset, int length) {
            long traceId = TcpServerFactory.this.supplyTraceId.getAsLong();
            int reserved = length + this.initialPadding;
            TcpServerFactory.this.doData(this.application, this.routeId, this.initialId, traceId, this.initialBudgetId, reserved, buffer, offset, length);
            this.initialBudget -= reserved;
            if (this.initialBudget <= this.initialPadding) {
                this.networkKey.clear(1);
            }
        }

        private void doApplicationEnd(long traceId) {
            TcpServerFactory.this.doEnd(this.application, this.routeId, this.initialId, traceId);
            this.counters.closesWritten.getAsLong();
            this.state = TcpState.closeInitial(this.state);
        }

        private void doApplicationAbort(long traceId) {
            TcpServerFactory.this.doAbort(this.application, this.routeId, this.initialId, traceId);
            this.counters.abortsWritten.getAsLong();
            this.state = TcpState.closeInitial(this.state);
        }

        private void doApplicationReset(long traceId) {
            TcpServerFactory.this.doReset(this.application, this.routeId, this.replyId, traceId);
            this.counters.resetsWritten.getAsLong();
            this.state = TcpState.closeReply(this.state);
        }

        private void doApplicationWindow(long traceId, int credit) {
            this.replyBudget += credit;
            TcpServerFactory.this.doWindow(this.application, this.routeId, this.replyId, traceId, 0, credit, 0);
        }

        private void doApplicationResetIfNecessary(long traceId) {
            if (!TcpState.replyClosing(this.state)) {
                if (TcpState.replyOpened(this.state)) {
                    assert (!TcpServerFactory.this.correlations.containsKey(this.replyId));
                    this.doApplicationReset(traceId);
                } else {
                    TcpServerFactory.this.correlations.remove(this.replyId);
                }
            }
        }

        private void doApplicationAbortIfNecessary(long traceId) {
            if (TcpState.initialOpened(this.state) && !TcpState.initialClosed(this.state)) {
                this.doApplicationAbort(traceId);
            }
        }

        private void doCleanup(long traceId, boolean abortiveRelease) {
            if (abortiveRelease) {
                try {
                    this.network.setOption((SocketOption)StandardSocketOptions.SO_LINGER, (Object)0);
                }
                catch (IOException ex) {
                    LangUtil.rethrowUnchecked((Throwable)ex);
                }
            }
            this.doCleanup(traceId);
        }

        private void doCleanup(long traceId) {
            this.doApplicationAbortIfNecessary(traceId);
            this.doApplicationResetIfNecessary(traceId);
            this.cleanupNetworkSlotIfNecessary();
            TcpServerFactory.this.doCloseNetwork(this.network);
        }

        private void cleanupNetworkSlotIfNecessary() {
            if (this.networkSlot != -1) {
                TcpServerFactory.this.bufferPool.release(this.networkSlot);
                this.networkSlot = -1;
                this.networkSlotOffset = 0;
            }
        }
    }
}

