/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.tls.internal;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.kaazing.k3po.lang.el.Function;
import org.kaazing.k3po.lang.el.spi.FunctionMapperSpi;
import org.reaktivity.specification.tls.internal.types.control.TlsRouteExFW;
import org.reaktivity.specification.tls.internal.types.stream.TlsBeginExFW;

public final class TlsFunctions {
    @Function
    public static byte[] randomBytes(int length) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)((Random)random).nextInt(256);
        }
        return bytes;
    }

    @Function
    public static TlsRouteExBuilder routeEx() {
        return new TlsRouteExBuilder();
    }

    @Function
    public static TlsBeginExBuilder beginEx() {
        return new TlsBeginExBuilder();
    }

    private TlsFunctions() {
    }

    public static class Mapper
    extends FunctionMapperSpi.Reflective {
        public Mapper() {
            super(TlsFunctions.class);
        }

        public String getPrefixName() {
            return "tls";
        }
    }

    public static final class TlsBeginExBuilder {
        private final TlsBeginExFW.Builder beginExRW;

        private TlsBeginExBuilder() {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[1024]);
            this.beginExRW = new TlsBeginExFW.Builder().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity());
        }

        public TlsBeginExBuilder typeId(int typeId) {
            this.beginExRW.typeId(typeId);
            return this;
        }

        public TlsBeginExBuilder hostname(String hostname) {
            this.beginExRW.hostname(hostname);
            return this;
        }

        public TlsBeginExBuilder protocol(String protocol) {
            this.beginExRW.protocol(protocol);
            return this;
        }

        public byte[] build() {
            TlsBeginExFW beginEx = this.beginExRW.build();
            byte[] array = new byte[beginEx.sizeof()];
            beginEx.buffer().getBytes(beginEx.offset(), array);
            return array;
        }
    }

    public static final class TlsRouteExBuilder {
        private final TlsRouteExFW.Builder routeExRW;

        private TlsRouteExBuilder() {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[1024]);
            this.routeExRW = new TlsRouteExFW.Builder().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity());
        }

        public TlsRouteExBuilder store(String store) {
            this.routeExRW.store(store);
            return this;
        }

        public TlsRouteExBuilder hostname(String hostname) {
            this.routeExRW.hostname(hostname);
            return this;
        }

        public TlsRouteExBuilder protocol(String protocol) {
            this.routeExRW.protocol(protocol);
            return this;
        }

        public byte[] build() {
            TlsRouteExFW routeEx = this.routeExRW.build();
            byte[] array = new byte[routeEx.sizeof()];
            routeEx.buffer().getBytes(routeEx.offset(), array);
            return array;
        }
    }
}

