/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.tls.internal.types.control;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.tls.internal.types.ArrayFW;
import org.reaktivity.specification.tls.internal.types.Flyweight;

public final class FrozenFW
extends Flyweight {
    public static final int FIELD_OFFSET_CORRELATION_ID = 0;
    private static final int FIELD_SIZE_CORRELATION_ID = 8;
    public static final int TYPE_ID = 0x40000003;

    public long correlationId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    public int typeId() {
        return 0x40000003;
    }

    @Override
    public FrozenFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        FrozenFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public FrozenFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 0 + 8;
    }

    public String toString() {
        return String.format("FROZEN [correlationId=%d]", this.correlationId());
    }

    public static final class Builder
    extends Flyweight.Builder<FrozenFW> {
        private static final int INDEX_CORRELATION_ID = 0;
        private static final int FIELD_COUNT = 1;
        private int lastFieldSet = -1;

        public Builder() {
            super(new FrozenFW());
        }

        public Builder correlationId(long value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 8;
            FrozenFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<FrozenFW>, ? extends Flyweight.Builder<FrozenFW>, FrozenFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public FrozenFW build() {
            assert (this.lastFieldSet == 0);
            this.lastFieldSet = -1;
            return (FrozenFW)super.build();
        }
    }
}

