/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.tls.internal.types.control;

import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.tls.internal.types.ArrayFW;
import org.reaktivity.specification.tls.internal.types.Flyweight;
import org.reaktivity.specification.tls.internal.types.String8FW;

public final class TlsRouteExFW
extends Flyweight {
    public static final int FIELD_OFFSET_STORE = 0;
    public static final int FIELD_OFFSET_HOSTNAME = 0;
    public static final int FIELD_OFFSET_PROTOCOL = 0;
    private final String8FW storeRO = new String8FW();
    private final String8FW hostnameRO = new String8FW();
    private final String8FW protocolRO = new String8FW();

    public String8FW store() {
        return this.storeRO;
    }

    public String8FW hostname() {
        return this.hostnameRO;
    }

    public String8FW protocol() {
        return this.protocolRO;
    }

    @Override
    public TlsRouteExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.storeRO.wrap(buffer, offset + 0, maxLimit);
        this.hostnameRO.wrap(buffer, this.storeRO.limit() + 0, maxLimit);
        this.protocolRO.wrap(buffer, this.hostnameRO.limit() + 0, maxLimit);
        TlsRouteExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public TlsRouteExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.storeRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (null == this.hostnameRO.tryWrap(buffer, this.storeRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.protocolRO.tryWrap(buffer, this.hostnameRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.protocolRO.limit();
    }

    public String toString() {
        return String.format("TLS_ROUTE_EX [store=%s, hostname=%s, protocol=%s]", this.storeRO.asString(), this.hostnameRO.asString(), this.protocolRO.asString());
    }

    public static final class Builder
    extends Flyweight.Builder<TlsRouteExFW> {
        private static final int INDEX_STORE = 0;
        private static final int INDEX_HOSTNAME = 1;
        private static final int INDEX_PROTOCOL = 2;
        private static final int FIELD_COUNT = 3;
        private final String8FW.Builder storeRW = new String8FW.Builder();
        private final String8FW.Builder hostnameRW = new String8FW.Builder();
        private final String8FW.Builder protocolRW = new String8FW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new TlsRouteExFW());
        }

        private String8FW.Builder store() {
            assert (this.lastFieldSet == -1);
            return this.storeRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder store(String value) {
            String8FW.Builder storeRW = this.store();
            storeRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 0;
            this.limit(storeRW.build().limit());
            return this;
        }

        public Builder store(String8FW value) {
            String8FW.Builder storeRW = this.store();
            storeRW.set(value);
            this.lastFieldSet = 0;
            this.limit(storeRW.build().limit());
            return this;
        }

        public Builder store(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder storeRW = this.store();
            storeRW.set(buffer, offset, length);
            this.lastFieldSet = 0;
            this.limit(storeRW.build().limit());
            return this;
        }

        private String8FW.Builder hostname() {
            assert (this.lastFieldSet == 0);
            return this.hostnameRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder hostname(String value) {
            String8FW.Builder hostnameRW = this.hostname();
            hostnameRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 1;
            this.limit(hostnameRW.build().limit());
            return this;
        }

        public Builder hostname(String8FW value) {
            String8FW.Builder hostnameRW = this.hostname();
            hostnameRW.set(value);
            this.lastFieldSet = 1;
            this.limit(hostnameRW.build().limit());
            return this;
        }

        public Builder hostname(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder hostnameRW = this.hostname();
            hostnameRW.set(buffer, offset, length);
            this.lastFieldSet = 1;
            this.limit(hostnameRW.build().limit());
            return this;
        }

        private String8FW.Builder protocol() {
            assert (this.lastFieldSet == 1);
            return this.protocolRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder protocol(String value) {
            String8FW.Builder protocolRW = this.protocol();
            protocolRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 2;
            this.limit(protocolRW.build().limit());
            return this;
        }

        public Builder protocol(String8FW value) {
            String8FW.Builder protocolRW = this.protocol();
            protocolRW.set(value);
            this.lastFieldSet = 2;
            this.limit(protocolRW.build().limit());
            return this;
        }

        public Builder protocol(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder protocolRW = this.protocol();
            protocolRW.set(buffer, offset, length);
            this.lastFieldSet = 2;
            this.limit(protocolRW.build().limit());
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<TlsRouteExFW>, ? extends Flyweight.Builder<TlsRouteExFW>, TlsRouteExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public TlsRouteExFW build() {
            assert (this.lastFieldSet == 2);
            this.lastFieldSet = -1;
            return (TlsRouteExFW)super.build();
        }
    }
}

