/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.tls.internal.types.stream;

import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.tls.internal.types.ArrayFW;
import org.reaktivity.specification.tls.internal.types.Flyweight;
import org.reaktivity.specification.tls.internal.types.String8FW;

public final class TlsBeginExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_HOSTNAME = 4;
    public static final int FIELD_OFFSET_PROTOCOL = 0;
    private final String8FW hostnameRO = new String8FW();
    private final String8FW protocolRO = new String8FW();

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public String8FW hostname() {
        return this.hostnameRO;
    }

    public String8FW protocol() {
        return this.protocolRO;
    }

    @Override
    public TlsBeginExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.hostnameRO.wrap(buffer, offset + 4, maxLimit);
        this.protocolRO.wrap(buffer, this.hostnameRO.limit() + 0, maxLimit);
        TlsBeginExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public TlsBeginExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.hostnameRO.tryWrap(buffer, offset + 4, maxLimit)) {
            return null;
        }
        if (null == this.protocolRO.tryWrap(buffer, this.hostnameRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.protocolRO.limit();
    }

    public String toString() {
        return String.format("TLS_BEGIN_EX [typeId=%d, hostname=%s, protocol=%s]", this.typeId(), this.hostnameRO.asString(), this.protocolRO.asString());
    }

    public static final class Builder
    extends Flyweight.Builder<TlsBeginExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private static final int INDEX_HOSTNAME = 1;
        private static final int INDEX_PROTOCOL = 2;
        private static final int FIELD_COUNT = 3;
        private final String8FW.Builder hostnameRW = new String8FW.Builder();
        private final String8FW.Builder protocolRW = new String8FW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new TlsBeginExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            TlsBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        private String8FW.Builder hostname() {
            assert (this.lastFieldSet == 0);
            return this.hostnameRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder hostname(String value) {
            String8FW.Builder hostnameRW = this.hostname();
            hostnameRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 1;
            this.limit(hostnameRW.build().limit());
            return this;
        }

        public Builder hostname(String8FW value) {
            String8FW.Builder hostnameRW = this.hostname();
            hostnameRW.set(value);
            this.lastFieldSet = 1;
            this.limit(hostnameRW.build().limit());
            return this;
        }

        public Builder hostname(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder hostnameRW = this.hostname();
            hostnameRW.set(buffer, offset, length);
            this.lastFieldSet = 1;
            this.limit(hostnameRW.build().limit());
            return this;
        }

        private String8FW.Builder protocol() {
            assert (this.lastFieldSet == 1);
            return this.protocolRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder protocol(String value) {
            String8FW.Builder protocolRW = this.protocol();
            protocolRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 2;
            this.limit(protocolRW.build().limit());
            return this;
        }

        public Builder protocol(String8FW value) {
            String8FW.Builder protocolRW = this.protocol();
            protocolRW.set(value);
            this.lastFieldSet = 2;
            this.limit(protocolRW.build().limit());
            return this;
        }

        public Builder protocol(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder protocolRW = this.protocol();
            protocolRW.set(buffer, offset, length);
            this.lastFieldSet = 2;
            this.limit(protocolRW.build().limit());
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<TlsBeginExFW>, ? extends Flyweight.Builder<TlsBeginExFW>, TlsBeginExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public TlsBeginExFW build() {
            assert (this.lastFieldSet == 2);
            this.lastFieldSet = -1;
            return (TlsBeginExFW)super.build();
        }
    }
}

