/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.specification.ws.internal.types.control;

import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.specification.ws.internal.types.ArrayFW;
import org.reaktivity.nukleus.specification.ws.internal.types.Flyweight;
import org.reaktivity.nukleus.specification.ws.internal.types.String8FW;

public final class UnrouteFW
extends Flyweight {
    public static final int FIELD_OFFSET_CORRELATION_ID = 0;
    private static final int FIELD_SIZE_CORRELATION_ID = 8;
    public static final int FIELD_OFFSET_NUKLEUS = 8;
    public static final int FIELD_OFFSET_ROUTE_ID = 0;
    private static final int FIELD_SIZE_ROUTE_ID = 8;
    public static final int TYPE_ID = 2;
    private final String8FW nukleusRO = new String8FW();

    public long correlationId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    public String8FW nukleus() {
        return this.nukleusRO;
    }

    public long routeId() {
        return this.buffer().getLong(this.nukleusRO.limit() + 0);
    }

    public int typeId() {
        return 2;
    }

    @Override
    public UnrouteFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.nukleusRO.wrap(buffer, offset + 8, maxLimit);
        UnrouteFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public UnrouteFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.nukleusRO.tryWrap(buffer, offset + 8, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.nukleusRO.limit() + 0 + 8;
    }

    public String toString() {
        return String.format("UNROUTE [correlationId=%d, nukleus=%s, routeId=%d]", this.correlationId(), this.nukleusRO.asString(), this.routeId());
    }

    public static final class Builder
    extends Flyweight.Builder<UnrouteFW> {
        private static final int INDEX_CORRELATION_ID = 0;
        private static final int INDEX_NUKLEUS = 1;
        private static final int INDEX_ROUTE_ID = 2;
        private static final int FIELD_COUNT = 3;
        private final String8FW.Builder nukleusRW = new String8FW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new UnrouteFW());
        }

        public Builder correlationId(long value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 8;
            UnrouteFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        private String8FW.Builder nukleus() {
            assert (this.lastFieldSet == 0);
            return this.nukleusRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder nukleus(String value) {
            String8FW.Builder nukleusRW = this.nukleus();
            nukleusRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 1;
            this.limit(nukleusRW.build().limit());
            return this;
        }

        public Builder nukleus(String8FW value) {
            String8FW.Builder nukleusRW = this.nukleus();
            nukleusRW.set(value);
            this.lastFieldSet = 1;
            this.limit(nukleusRW.build().limit());
            return this;
        }

        public Builder nukleus(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder nukleusRW = this.nukleus();
            nukleusRW.set(buffer, offset, length);
            this.lastFieldSet = 1;
            this.limit(nukleusRW.build().limit());
            return this;
        }

        public Builder routeId(long value) {
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + 8;
            UnrouteFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 2;
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<UnrouteFW>, ? extends Flyweight.Builder<UnrouteFW>, UnrouteFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public UnrouteFW build() {
            assert (this.lastFieldSet == 2);
            this.lastFieldSet = -1;
            return (UnrouteFW)super.build();
        }
    }
}

