/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.specification.ws.internal.types.stream;

import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.specification.ws.internal.types.ArrayFW;
import org.reaktivity.nukleus.specification.ws.internal.types.Flyweight;
import org.reaktivity.nukleus.specification.ws.internal.types.String8FW;

public final class WsBeginExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_PROTOCOL = 4;
    public static final int FIELD_OFFSET_SCHEME = 0;
    public static final int FIELD_OFFSET_AUTHORITY = 0;
    public static final int FIELD_OFFSET_PATH = 0;
    private final String8FW protocolRO = new String8FW();
    private final String8FW schemeRO = new String8FW();
    private final String8FW authorityRO = new String8FW();
    private final String8FW pathRO = new String8FW();

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public String8FW protocol() {
        return this.protocolRO;
    }

    public String8FW scheme() {
        return this.schemeRO;
    }

    public String8FW authority() {
        return this.authorityRO;
    }

    public String8FW path() {
        return this.pathRO;
    }

    @Override
    public WsBeginExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.protocolRO.wrap(buffer, offset + 4, maxLimit);
        this.schemeRO.wrap(buffer, this.protocolRO.limit() + 0, maxLimit);
        this.authorityRO.wrap(buffer, this.schemeRO.limit() + 0, maxLimit);
        this.pathRO.wrap(buffer, this.authorityRO.limit() + 0, maxLimit);
        WsBeginExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public WsBeginExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.protocolRO.tryWrap(buffer, offset + 4, maxLimit)) {
            return null;
        }
        if (null == this.schemeRO.tryWrap(buffer, this.protocolRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.authorityRO.tryWrap(buffer, this.schemeRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.pathRO.tryWrap(buffer, this.authorityRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.pathRO.limit();
    }

    public String toString() {
        return String.format("WS_BEGIN_EX [typeId=%d, protocol=%s, scheme=%s, authority=%s, path=%s]", this.typeId(), this.protocolRO.asString(), this.schemeRO.asString(), this.authorityRO.asString(), this.pathRO.asString());
    }

    public static final class Builder
    extends Flyweight.Builder<WsBeginExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private static final int INDEX_PROTOCOL = 1;
        private static final int INDEX_SCHEME = 2;
        private static final int INDEX_AUTHORITY = 3;
        private static final int INDEX_PATH = 4;
        private static final int FIELD_COUNT = 5;
        private final String8FW.Builder protocolRW = new String8FW.Builder();
        private final String8FW.Builder schemeRW = new String8FW.Builder();
        private final String8FW.Builder authorityRW = new String8FW.Builder();
        private final String8FW.Builder pathRW = new String8FW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new WsBeginExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            WsBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        private String8FW.Builder protocol() {
            assert (this.lastFieldSet == 0);
            return this.protocolRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder protocol(String value) {
            String8FW.Builder protocolRW = this.protocol();
            protocolRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 1;
            this.limit(protocolRW.build().limit());
            return this;
        }

        public Builder protocol(String8FW value) {
            String8FW.Builder protocolRW = this.protocol();
            protocolRW.set(value);
            this.lastFieldSet = 1;
            this.limit(protocolRW.build().limit());
            return this;
        }

        public Builder protocol(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder protocolRW = this.protocol();
            protocolRW.set(buffer, offset, length);
            this.lastFieldSet = 1;
            this.limit(protocolRW.build().limit());
            return this;
        }

        private String8FW.Builder scheme() {
            assert (this.lastFieldSet == 1);
            return this.schemeRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder scheme(String value) {
            String8FW.Builder schemeRW = this.scheme();
            schemeRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 2;
            this.limit(schemeRW.build().limit());
            return this;
        }

        public Builder scheme(String8FW value) {
            String8FW.Builder schemeRW = this.scheme();
            schemeRW.set(value);
            this.lastFieldSet = 2;
            this.limit(schemeRW.build().limit());
            return this;
        }

        public Builder scheme(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder schemeRW = this.scheme();
            schemeRW.set(buffer, offset, length);
            this.lastFieldSet = 2;
            this.limit(schemeRW.build().limit());
            return this;
        }

        private String8FW.Builder authority() {
            assert (this.lastFieldSet == 2);
            return this.authorityRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder authority(String value) {
            String8FW.Builder authorityRW = this.authority();
            authorityRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 3;
            this.limit(authorityRW.build().limit());
            return this;
        }

        public Builder authority(String8FW value) {
            String8FW.Builder authorityRW = this.authority();
            authorityRW.set(value);
            this.lastFieldSet = 3;
            this.limit(authorityRW.build().limit());
            return this;
        }

        public Builder authority(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder authorityRW = this.authority();
            authorityRW.set(buffer, offset, length);
            this.lastFieldSet = 3;
            this.limit(authorityRW.build().limit());
            return this;
        }

        private String8FW.Builder path() {
            assert (this.lastFieldSet == 3);
            return this.pathRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder path(String value) {
            String8FW.Builder pathRW = this.path();
            pathRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 4;
            this.limit(pathRW.build().limit());
            return this;
        }

        public Builder path(String8FW value) {
            String8FW.Builder pathRW = this.path();
            pathRW.set(value);
            this.lastFieldSet = 4;
            this.limit(pathRW.build().limit());
            return this;
        }

        public Builder path(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder pathRW = this.path();
            pathRW.set(buffer, offset, length);
            this.lastFieldSet = 4;
            this.limit(pathRW.build().limit());
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<WsBeginExFW>, ? extends Flyweight.Builder<WsBeginExFW>, WsBeginExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public WsBeginExFW build() {
            assert (this.lastFieldSet == 4);
            this.lastFieldSet = -1;
            return (WsBeginExFW)super.build();
        }
    }
}

