/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.specification.ws.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.specification.ws.internal.types.ArrayFW;
import org.reaktivity.nukleus.specification.ws.internal.types.Flyweight;
import org.reaktivity.nukleus.specification.ws.internal.types.OctetsFW;

public final class WsDataExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_FLAGS = 4;
    private static final int FIELD_SIZE_FLAGS = 1;
    public static final int FIELD_OFFSET_INFO = 5;
    private final OctetsFW infoRO = new OctetsFW();

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public int flags() {
        return this.buffer().getByte(this.offset() + 4) & 0xFF;
    }

    public OctetsFW info() {
        return this.infoRO;
    }

    @Override
    public WsDataExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.infoRO.wrap(buffer, offset + 5, maxLimit);
        WsDataExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public WsDataExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.infoRO.tryWrap(buffer, offset + 5, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.infoRO.limit();
    }

    public String toString() {
        return String.format("WS_DATA_EX [typeId=%d, flags=%d, info=%s]", this.typeId(), this.flags(), this.info());
    }

    public static final class Builder
    extends Flyweight.Builder<WsDataExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private static final int INDEX_FLAGS = 1;
        private static final int INDEX_INFO = 2;
        private static final int FIELD_COUNT = 3;
        private final OctetsFW.Builder infoRW = new OctetsFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new WsDataExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            WsDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder flags(int value) {
            if (value < 0) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"flags\"", value));
            }
            if (value > 255) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"flags\"", value));
            }
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 1;
            WsDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putByte(this.limit(), (byte)(value & 0xFF));
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        private OctetsFW.Builder info() {
            assert (this.lastFieldSet == 1);
            return this.infoRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder info(OctetsFW value) {
            OctetsFW.Builder infoRW = this.info();
            infoRW.set(value);
            this.limit(((OctetsFW)infoRW.build()).limit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder info(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder infoRW = this.info();
            mutator.accept(infoRW);
            this.limit(((OctetsFW)infoRW.build()).limit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder info(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder infoRW = this.info();
            infoRW.set(buffer, offset, length);
            this.limit(((OctetsFW)infoRW.build()).limit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<WsDataExFW>, ? extends Flyweight.Builder<WsDataExFW>, WsDataExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public WsDataExFW build() {
            if (this.lastFieldSet < 2) {
                this.info((OctetsFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 2);
            this.lastFieldSet = -1;
            return (WsDataExFW)super.build();
        }
    }
}

