/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.specification.ws.internal.types.stream;

import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.specification.ws.internal.types.ArrayFW;
import org.reaktivity.nukleus.specification.ws.internal.types.Flyweight;
import org.reaktivity.nukleus.specification.ws.internal.types.String8FW;

public final class WsEndExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_CODE = 4;
    private static final int FIELD_SIZE_CODE = 2;
    public static final int FIELD_OFFSET_REASON = 6;
    private final String8FW reasonRO = new String8FW();

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public short code() {
        return this.buffer().getShort(this.offset() + 4);
    }

    public String8FW reason() {
        return this.reasonRO;
    }

    @Override
    public WsEndExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.reasonRO.wrap(buffer, offset + 6, maxLimit);
        WsEndExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public WsEndExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.reasonRO.tryWrap(buffer, offset + 6, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.reasonRO.limit();
    }

    public String toString() {
        return String.format("WS_END_EX [typeId=%d, code=%d, reason=%s]", this.typeId(), this.code(), this.reasonRO.asString());
    }

    public static final class Builder
    extends Flyweight.Builder<WsEndExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private static final int INDEX_CODE = 1;
        private static final int INDEX_REASON = 2;
        private static final int FIELD_COUNT = 3;
        private final String8FW.Builder reasonRW = new String8FW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new WsEndExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            WsEndExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder code(short value) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 2;
            WsEndExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putShort(this.limit(), value);
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        private String8FW.Builder reason() {
            assert (this.lastFieldSet == 1);
            return this.reasonRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder reason(String value) {
            String8FW.Builder reasonRW = this.reason();
            reasonRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 2;
            this.limit(reasonRW.build().limit());
            return this;
        }

        public Builder reason(String8FW value) {
            String8FW.Builder reasonRW = this.reason();
            reasonRW.set(value);
            this.lastFieldSet = 2;
            this.limit(reasonRW.build().limit());
            return this;
        }

        public Builder reason(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder reasonRW = this.reason();
            reasonRW.set(buffer, offset, length);
            this.lastFieldSet = 2;
            this.limit(reasonRW.build().limit());
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<WsEndExFW>, ? extends Flyweight.Builder<WsEndExFW>, WsEndExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public WsEndExFW build() {
            assert (this.lastFieldSet == 2);
            this.lastFieldSet = -1;
            return (WsEndExFW)super.build();
        }
    }
}

