/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.ws.internal;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.concurrent.ThreadLocalRandom;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.kaazing.k3po.lang.el.Function;
import org.kaazing.k3po.lang.el.spi.FunctionMapperSpi;
import org.reaktivity.nukleus.specification.ws.internal.types.control.WsRouteExFW;
import org.reaktivity.nukleus.specification.ws.internal.types.stream.WsBeginExFW;

public final class WsFunctions {
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    private static final int MAX_BUFFER_SIZE = 8192;
    private static final byte[] WEBSOCKET_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes(StandardCharsets.US_ASCII);

    @Function
    public static WsRouteExHelper routeEx() {
        return new WsRouteExHelper();
    }

    @Function
    public static WsBeginExHelper beginEx() {
        return new WsBeginExHelper();
    }

    @Function
    public static String handshakeKey() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        byte[] bytes = new byte[16];
        random.nextBytes(bytes);
        return BASE64_ENCODER.encodeToString(bytes);
    }

    @Function
    public static String handshakeHash(String wsKey) throws NoSuchAlgorithmException {
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        sha1.update(wsKey.getBytes(StandardCharsets.US_ASCII));
        byte[] digest = sha1.digest(WEBSOCKET_GUID);
        return BASE64_ENCODER.encodeToString(digest);
    }

    private WsFunctions() {
    }

    public static class Mapper
    extends FunctionMapperSpi.Reflective {
        public Mapper() {
            super(WsFunctions.class);
        }

        public String getPrefixName() {
            return "ws";
        }
    }

    public static final class WsBeginExHelper {
        private final WsBeginExFW.Builder wsBeginExRW;

        private WsBeginExHelper() {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[8192]);
            this.wsBeginExRW = new WsBeginExFW.Builder().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity());
        }

        public WsBeginExHelper typeId(int typeId) {
            this.wsBeginExRW.typeId(typeId);
            return this;
        }

        public WsBeginExHelper protocol(String protocol) {
            this.wsBeginExRW.protocol(protocol);
            return this;
        }

        public WsBeginExHelper scheme(String scheme) {
            this.wsBeginExRW.scheme(scheme);
            return this;
        }

        public WsBeginExHelper authority(String authority) {
            this.wsBeginExRW.authority(authority);
            return this;
        }

        public WsBeginExHelper path(String path) {
            this.wsBeginExRW.path(path);
            return this;
        }

        public byte[] build() {
            WsBeginExFW wsBeginEx = this.wsBeginExRW.build();
            byte[] result = new byte[wsBeginEx.sizeof()];
            wsBeginEx.buffer().getBytes(0, result);
            return result;
        }
    }

    public static final class WsRouteExHelper {
        private final WsRouteExFW.Builder wsRouteExRW;

        private WsRouteExHelper() {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[8192]);
            this.wsRouteExRW = new WsRouteExFW.Builder().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity());
        }

        public WsRouteExHelper protocol(String protocol) {
            this.wsRouteExRW.protocol(protocol);
            return this;
        }

        public WsRouteExHelper scheme(String scheme) {
            this.wsRouteExRW.scheme(scheme);
            return this;
        }

        public WsRouteExHelper authority(String authority) {
            this.wsRouteExRW.authority(authority);
            return this;
        }

        public WsRouteExHelper path(String path) {
            this.wsRouteExRW.path(path);
            return this;
        }

        public byte[] build() {
            WsRouteExFW wsRouteEx = this.wsRouteExRW.build();
            byte[] result = new byte[wsRouteEx.sizeof()];
            wsRouteEx.buffer().getBytes(0, result);
            return result;
        }
    }
}

