/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.Random;
import org.agrona.BitUtil;
import org.agrona.CloseHelper;
import org.agrona.IoUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.broadcast.BroadcastBufferDescriptor;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;
import org.agrona.concurrent.ringbuffer.RingBufferDescriptor;
import org.kaazing.k3po.lang.el.Function;
import org.kaazing.k3po.lang.el.spi.FunctionMapperSpi;

public final class Functions {
    private static final Random RANDOM = new Random();
    private static final int CONTROL_VERSION = 1;
    private static final int FIELD_OFFSET_VERSION = 0;
    private static final int FIELD_SIZE_VERSION = 4;
    private static final int FIELD_OFFSET_COMMAND_BUFFER_LENGTH = 4;
    private static final int FIELD_SIZE_COMMAND_BUFFER_LENGTH = 4;
    private static final int FIELD_OFFSET_RESPONSE_BUFFER_LENGTH = 8;
    private static final int FIELD_SIZE_RESPONSE_BUFFER_LENGTH = 4;
    private static final int FIELD_OFFSET_COUNTER_LABELS_BUFFER_LENGTH = 12;
    private static final int FIELD_SIZE_COUNTER_LABELS_BUFFER_LENGTH = 4;
    private static final int FIELD_OFFSET_COUNTER_VALUES_BUFFER_LENGTH = 16;
    private static final int FIELD_SIZE_COUNTER_VALUES_BUFFER_LENGTH = 4;
    private static final int END_OF_META_DATA_OFFSET = BitUtil.align((int)20, (int)64);

    @Function
    public static Helper directory(String configPath) {
        return new Helper(new File(configPath));
    }

    @Function
    public static Long newReferenceId() {
        return RANDOM.nextLong();
    }

    @Function
    public static Long newStreamId() {
        return RANDOM.nextLong();
    }

    @Function
    public static Long newCorrelationId() {
        return RANDOM.nextLong();
    }

    private Functions() {
    }

    public static class Mapper
    extends FunctionMapperSpi.Reflective {
        public Mapper() {
            super(Functions.class);
        }

        public String getPrefixName() {
            return "nuklei";
        }
    }

    public static final class Helper {
        private final File configDirectory;
        private int ringCapacity;
        private int broadcastCapacity;

        private Helper(File configDirectory) {
            this.configDirectory = configDirectory;
        }

        public Helper controlCapacity(int ringCapacity, int broadcastCapacity) {
            this.ringCapacity = ringCapacity;
            this.broadcastCapacity = broadcastCapacity;
            return this;
        }

        public ControlHelper controlNew() {
            return new ControlHelper.Eager(true, new File(this.configDirectory, "control"), this.ringCapacity, this.broadcastCapacity);
        }

        public ControlHelper control() {
            return new ControlHelper.Deferred(false, new File(this.configDirectory, "control"), this.ringCapacity, this.broadcastCapacity);
        }

        public static abstract class ControlHelper
        implements AutoCloseable {
            private long correlationId;

            public abstract AtomicBuffer getNukleus();

            public abstract AtomicBuffer getController();

            public final long nextCorrelationId() {
                ManyToOneRingBuffer ring = new ManyToOneRingBuffer(this.getNukleus());
                this.correlationId = ring.nextCorrelationId();
                return this.correlationId;
            }

            public final long correlationId() {
                return this.correlationId;
            }

            private static final class Deferred
            extends ControlHelper {
                private final boolean overwrite;
                private final File location;
                private final int ringCapacity;
                private final int broadcastCapacity;
                private Eager delegate;

                private Deferred(boolean overwrite, File location, int ringCapacity, int broadcastCapacity) {
                    this.overwrite = overwrite;
                    this.location = location;
                    this.ringCapacity = ringCapacity;
                    this.broadcastCapacity = broadcastCapacity;
                }

                @Override
                public AtomicBuffer getNukleus() {
                    this.ensureInitialized();
                    return this.delegate.nukleus;
                }

                @Override
                public AtomicBuffer getController() {
                    this.ensureInitialized();
                    return this.delegate.controller;
                }

                @Override
                public void close() throws Exception {
                    if (this.delegate != null) {
                        this.delegate.close();
                    }
                }

                public String toString() {
                    return String.format("controlCapacity(%d, %d)", this.ringCapacity, this.broadcastCapacity);
                }

                void ensureInitialized() {
                    if (this.delegate == null) {
                        this.delegate = new Eager(this.overwrite, this.location, this.ringCapacity, this.broadcastCapacity);
                    }
                }
            }

            private static final class Eager
            extends ControlHelper {
                private final MappedByteBuffer buffer;
                private final AtomicBuffer nukleus;
                private final AtomicBuffer controller;

                private Eager(boolean overwrite, File location, int commandBufferCapacity, int responseBufferCapacity) {
                    int responseBufferLength;
                    int commandBufferLength;
                    File controlFile = location.getAbsoluteFile();
                    int counterLabelsBufferCapacity = 0;
                    int counterValuesBufferCapacity = 0;
                    if (overwrite) {
                        commandBufferLength = commandBufferCapacity + RingBufferDescriptor.TRAILER_LENGTH;
                        responseBufferLength = responseBufferCapacity + BroadcastBufferDescriptor.TRAILER_LENGTH;
                        int counterLabelsBufferLength = counterLabelsBufferCapacity;
                        int counterValuesBufferLength = counterValuesBufferCapacity;
                        CloseHelper.close((AutoCloseable)IoUtil.createEmptyFile((File)controlFile, (long)(END_OF_META_DATA_OFFSET + commandBufferLength + responseBufferLength + counterLabelsBufferLength + counterValuesBufferLength)));
                        MappedByteBuffer metadata = IoUtil.mapExistingFile((File)controlFile, (String)"metadata", (long)0L, (long)END_OF_META_DATA_OFFSET);
                        metadata.putInt(0, 1);
                        metadata.putInt(4, commandBufferCapacity);
                        metadata.putInt(8, responseBufferCapacity);
                        metadata.putInt(12, counterLabelsBufferCapacity);
                        metadata.putInt(16, counterValuesBufferCapacity);
                        IoUtil.unmap((MappedByteBuffer)metadata);
                    } else {
                        MappedByteBuffer metadata = IoUtil.mapExistingFile((File)controlFile, (String)"metadata", (long)0L, (long)END_OF_META_DATA_OFFSET);
                        assert (1 == metadata.getInt(0));
                        commandBufferCapacity = metadata.getInt(4);
                        responseBufferCapacity = metadata.getInt(8);
                        counterLabelsBufferCapacity = metadata.getInt(12);
                        counterValuesBufferCapacity = metadata.getInt(16);
                        IoUtil.unmap((MappedByteBuffer)metadata);
                    }
                    commandBufferLength = commandBufferCapacity + RingBufferDescriptor.TRAILER_LENGTH;
                    responseBufferLength = responseBufferCapacity + BroadcastBufferDescriptor.TRAILER_LENGTH;
                    int commandBufferOffset = END_OF_META_DATA_OFFSET;
                    this.buffer = IoUtil.mapExistingFile((File)controlFile, (String)"commands");
                    this.nukleus = new UnsafeBuffer((ByteBuffer)this.buffer, commandBufferOffset, commandBufferLength);
                    int responseBufferOffset = commandBufferOffset + commandBufferLength;
                    this.controller = new UnsafeBuffer((ByteBuffer)this.buffer, responseBufferOffset, responseBufferLength);
                }

                @Override
                public AtomicBuffer getNukleus() {
                    return this.nukleus;
                }

                @Override
                public AtomicBuffer getController() {
                    return this.controller;
                }

                @Override
                public void close() {
                    IoUtil.unmap((MappedByteBuffer)this.buffer);
                }

                public String toString() {
                    return String.format("controlCapacity(%d, %d)", this.nukleus.capacity(), this.controller.capacity());
                }
            }
        }
    }
}

