/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus.internal.types.control;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.nukleus.internal.types.ArrayFW;
import org.reaktivity.specification.nukleus.internal.types.Flyweight;

public final class ResolvedFW
extends Flyweight {
    public static final int FIELD_OFFSET_CORRELATION_ID = 0;
    private static final int FIELD_SIZE_CORRELATION_ID = 8;
    public static final int FIELD_OFFSET_AUTHORIZATION = 8;
    private static final int FIELD_SIZE_AUTHORIZATION = 8;
    public static final int TYPE_ID = 0x40000011;

    public long correlationId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    public long authorization() {
        return this.buffer().getLong(this.offset() + 8);
    }

    public int typeId() {
        return 0x40000011;
    }

    @Override
    public ResolvedFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        ResolvedFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public ResolvedFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 8 + 8;
    }

    public String toString() {
        return String.format("RESOLVED [correlationId=%d, authorization=%d]", this.correlationId(), this.authorization());
    }

    public static final class Builder
    extends Flyweight.Builder<ResolvedFW> {
        private static final int INDEX_CORRELATION_ID = 0;
        private static final int INDEX_AUTHORIZATION = 1;
        private static final int FIELD_COUNT = 2;
        private int lastFieldSet = -1;

        public Builder() {
            super(new ResolvedFW());
        }

        public Builder correlationId(long value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 8;
            ResolvedFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder authorization(long value) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 8;
            ResolvedFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<ResolvedFW>, ? extends Flyweight.Builder<ResolvedFW>, ResolvedFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public ResolvedFW build() {
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (ResolvedFW)super.build();
        }
    }
}

