/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus.internal.types.stream;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.nukleus.internal.types.ArrayFW;
import org.reaktivity.specification.nukleus.internal.types.Flyweight;

public final class ExtensionFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_TYPE_ID = 4;

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    @Override
    public ExtensionFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        ExtensionFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public ExtensionFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 0 + 4;
    }

    public String toString() {
        return String.format("EXTENSION [typeId=%d]", this.typeId());
    }

    public static final class Builder
    extends Flyweight.Builder<ExtensionFW> {
        private static final int INDEX_TYPE_ID = 0;
        private static final int FIELD_COUNT = 1;
        private int lastFieldSet = -1;

        public Builder() {
            super(new ExtensionFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            ExtensionFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<ExtensionFW>, ? extends Flyweight.Builder<ExtensionFW>, ExtensionFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public ExtensionFW build() {
            assert (this.lastFieldSet == 0);
            this.lastFieldSet = -1;
            return (ExtensionFW)super.build();
        }
    }
}

