/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus.streams;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.util.Random;
import org.agrona.IoUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.ringbuffer.RingBufferDescriptor;
import org.kaazing.k3po.lang.el.Function;
import org.kaazing.k3po.lang.el.spi.FunctionMapperSpi;

@Deprecated
public final class Functions {
    private static final Random RANDOM = new Random();

    @Function
    public static byte[] newReferenceId() {
        return Functions.longToBytesNative(RANDOM.nextLong() & 0x3FFFFFFFFFFFFFFFL);
    }

    @Function
    public static byte[] newInitialStreamId() {
        return Functions.longToBytesNative(RANDOM.nextLong() & 0x3FFFFFFFFFFFFFFFL | 1L);
    }

    @Function
    public static byte[] newReplyStreamId() {
        long value;
        while ((value = RANDOM.nextLong() & 0x3FFFFFFFFFFFFFFEL) == 0L) {
        }
        return Functions.longToBytesNative(value);
    }

    @Function
    public static Layout map(String filename, int streamCapacity) {
        return new DeferredLayout(new File(filename), streamCapacity);
    }

    private static byte[] longToBytesNative(long value) {
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            return new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        }
        return new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24), (byte)(value >> 32), (byte)(value >> 40), (byte)(value >> 48), (byte)(value >> 56)};
    }

    private Functions() {
    }

    public static class Mapper
    extends FunctionMapperSpi.Reflective {
        public Mapper() {
            super(Functions.class);
        }

        public String getPrefixName() {
            return "streams";
        }
    }

    public static final class DeferredLayout
    extends Layout {
        private final File location;
        private final int streamCapacity;
        private EagerLayout delegate;

        public DeferredLayout(File location, int streamCapacity) {
            this.location = location;
            this.streamCapacity = streamCapacity;
        }

        @Override
        public AtomicBuffer getBuffer() {
            this.ensureInitialized();
            return this.delegate.atomicBuffer;
        }

        @Override
        public void close() throws Exception {
            if (this.delegate != null) {
                this.delegate.close();
            }
        }

        public String toString() {
            return String.format("Layout [%s]", this.location);
        }

        void ensureInitialized() {
            if (this.delegate == null) {
                this.delegate = new EagerLayout(this.location, this.streamCapacity);
            }
        }
    }

    public static final class EagerLayout
    extends Layout {
        private final MappedByteBuffer byteBuffer;
        private final AtomicBuffer atomicBuffer;

        public EagerLayout(File location, int streamCapacity) {
            File absolute = location.getAbsoluteFile();
            int length = streamCapacity + RingBufferDescriptor.TRAILER_LENGTH;
            this.byteBuffer = IoUtil.mapExistingFile((File)absolute, (String)location.getAbsolutePath());
            this.atomicBuffer = new UnsafeBuffer((ByteBuffer)this.byteBuffer, 0, length);
        }

        @Override
        public AtomicBuffer getBuffer() {
            return this.atomicBuffer;
        }

        @Override
        public void close() {
            IoUtil.unmap((MappedByteBuffer)this.byteBuffer);
        }
    }

    private static abstract class Layout
    implements AutoCloseable {
        private Layout() {
        }

        public abstract AtomicBuffer getBuffer();
    }
}

