/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus;

import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.agrona.BitUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.kaazing.k3po.lang.el.Function;
import org.kaazing.k3po.lang.el.spi.FunctionMapperSpi;
import org.reaktivity.specification.nukleus.internal.types.String16FW;
import org.reaktivity.specification.nukleus.internal.types.String8FW;
import org.reaktivity.specification.nukleus.internal.types.control.Capability;

public final class CoreFunctions {
    private static final ThreadLocal<String8FW.Builder> STRING_RW = ThreadLocal.withInitial(String8FW.Builder::new);
    private static final ThreadLocal<String16FW.Builder> STRING16_RW = ThreadLocal.withInitial(String16FW.Builder::new);

    @Function
    public static byte[] fromHex(String text) {
        return BitUtil.fromHex((String)text);
    }

    @Function
    public static Random random() {
        return ThreadLocalRandom.current();
    }

    @Function
    public static byte[] string(String text) {
        int capacity = 1 + Optional.ofNullable(text).orElse("").length() * 2 + 1;
        UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[capacity]);
        String8FW string = STRING_RW.get().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity()).set(text, StandardCharsets.UTF_8).build();
        byte[] array = new byte[string.sizeof()];
        string.buffer().getBytes(0, array);
        return array;
    }

    @Function
    public static byte[] string16(String text) {
        int capacity = 2 + Optional.ofNullable(text).orElse("").length() * 2 + 1;
        UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[capacity]);
        String16FW string16 = STRING16_RW.get().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity()).set(text, StandardCharsets.UTF_8).build();
        byte[] array = new byte[string16.sizeof()];
        string16.buffer().getBytes(0, array);
        return array;
    }

    @Function
    public static byte capabilities(String capability, String ... optionalCapabilities) {
        return CoreFunctions.of(capability, optionalCapabilities);
    }

    private static byte of(String name, String ... optionalNames) {
        byte capabilityMask = 0;
        capabilityMask = (byte)(capabilityMask | 1 << Capability.valueOf(name).ordinal());
        for (int i = 0; i < optionalNames.length; ++i) {
            int capabilityOrdinal = Capability.valueOf(optionalNames[i]).ordinal();
            assert (capabilityOrdinal < 8);
            capabilityMask = (byte)(capabilityMask | 1 << capabilityOrdinal);
        }
        return capabilityMask;
    }

    private CoreFunctions() {
    }

    public static class Mapper
    extends FunctionMapperSpi.Reflective {
        public Mapper() {
            super(CoreFunctions.class);
        }

        public String getPrefixName() {
            return "core";
        }
    }
}

