/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus;

import java.io.File;
import org.agrona.CloseHelper;
import org.agrona.IoUtil;
import org.agrona.concurrent.ringbuffer.RingBufferDescriptor;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class NukleusRule
implements TestRule {
    private static final int STREAMS_BUFFER_CAPACITY_DEFAULT = 0x100000;
    private static final int THROTTLE_BUFFER_CAPACITY_DEFAULT = 65536;
    private File directory;
    private long streamsBufferCapacity = 0x100000L;
    private long throttleBufferCapacity = 65536L;

    public NukleusRule directory(String directory) {
        this.directory = new File("./" + directory);
        return this;
    }

    public NukleusRule streamsBufferCapacity(int streamsBufferCapacity) {
        this.streamsBufferCapacity = streamsBufferCapacity;
        return this;
    }

    public NukleusRule throttleBufferCapacity(int throttleBufferCapacity) {
        this.throttleBufferCapacity = throttleBufferCapacity;
        return this;
    }

    public NukleusRule streams(String nukleus, String source) {
        File streams = new File(this.directory, String.format("%s/streams/%s", nukleus, source));
        long streamsBufferSize = this.streamsBufferCapacity + (long)RingBufferDescriptor.TRAILER_LENGTH;
        long throttleBufferSize = this.throttleBufferCapacity + (long)RingBufferDescriptor.TRAILER_LENGTH;
        CloseHelper.close((AutoCloseable)IoUtil.createEmptyFile((File)streams.getAbsoluteFile(), (long)(streamsBufferSize + throttleBufferSize)));
        return this;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                base.evaluate();
            }
        };
    }
}

