/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus.internal.types.control;

import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.nukleus.internal.types.ArrayFW;
import org.reaktivity.specification.nukleus.internal.types.Flyweight;
import org.reaktivity.specification.nukleus.internal.types.String8FW;

public final class CommandFW
extends Flyweight {
    public static final int FIELD_OFFSET_CORRELATION_ID = 0;
    private static final int FIELD_SIZE_CORRELATION_ID = 8;
    public static final int FIELD_OFFSET_NUKLEUS = 8;
    private final String8FW nukleusRO = new String8FW();

    public long correlationId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    public String8FW nukleus() {
        return this.nukleusRO;
    }

    @Override
    public CommandFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.nukleusRO.wrap(buffer, offset + 8, maxLimit);
        CommandFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public CommandFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.nukleusRO.tryWrap(buffer, offset + 8, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.nukleusRO.limit();
    }

    public String toString() {
        return String.format("COMMAND [correlationId=%d, nukleus=%s]", this.correlationId(), this.nukleusRO.asString());
    }

    public static final class Builder
    extends Flyweight.Builder<CommandFW> {
        private static final int INDEX_CORRELATION_ID = 0;
        private static final int INDEX_NUKLEUS = 1;
        private static final int FIELD_COUNT = 2;
        private final String8FW.Builder nukleusRW = new String8FW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new CommandFW());
        }

        public Builder correlationId(long value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 8;
            CommandFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        private String8FW.Builder nukleus() {
            assert (this.lastFieldSet == 0);
            return this.nukleusRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder nukleus(String value) {
            String8FW.Builder nukleusRW = this.nukleus();
            nukleusRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 1;
            this.limit(nukleusRW.build().limit());
            return this;
        }

        public Builder nukleus(String8FW value) {
            String8FW.Builder nukleusRW = this.nukleus();
            nukleusRW.set((Flyweight)value);
            this.lastFieldSet = 1;
            this.limit(nukleusRW.build().limit());
            return this;
        }

        public Builder nukleus(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder nukleusRW = this.nukleus();
            nukleusRW.set(buffer, offset, length);
            this.lastFieldSet = 1;
            this.limit(nukleusRW.build().limit());
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public CommandFW build() {
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (CommandFW)super.build();
        }
    }
}

