/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.nukleus.internal.types.ArrayFW;
import org.reaktivity.specification.nukleus.internal.types.Flyweight;
import org.reaktivity.specification.nukleus.internal.types.OctetsFW;

public final class DataFW
extends Flyweight {
    public static final int FIELD_OFFSET_ROUTE_ID = 0;
    private static final int FIELD_SIZE_ROUTE_ID = 8;
    public static final int FIELD_OFFSET_STREAM_ID = 8;
    private static final int FIELD_SIZE_STREAM_ID = 8;
    public static final int FIELD_OFFSET_SEQUENCE = 16;
    private static final int FIELD_SIZE_SEQUENCE = 8;
    public static final int FIELD_OFFSET_ACKNOWLEDGE = 24;
    private static final int FIELD_SIZE_ACKNOWLEDGE = 8;
    public static final int FIELD_OFFSET_MAXIMUM = 32;
    private static final int FIELD_SIZE_MAXIMUM = 4;
    public static final int FIELD_OFFSET_TIMESTAMP = 36;
    private static final int FIELD_SIZE_TIMESTAMP = 8;
    public static final int FIELD_OFFSET_TRACE_ID = 44;
    private static final int FIELD_SIZE_TRACE_ID = 8;
    public static final int FIELD_OFFSET_AUTHORIZATION = 52;
    private static final int FIELD_SIZE_AUTHORIZATION = 8;
    public static final int FIELD_OFFSET_FLAGS = 60;
    private static final int FIELD_SIZE_FLAGS = 1;
    public static final int FIELD_OFFSET_BUDGET_ID = 61;
    private static final int FIELD_SIZE_BUDGET_ID = 8;
    public static final int FIELD_OFFSET_RESERVED = 69;
    private static final int FIELD_SIZE_RESERVED = 4;
    public static final int FIELD_OFFSET_LENGTH = 73;
    private static final int FIELD_SIZE_LENGTH = 4;
    public static final int FIELD_OFFSET_PAYLOAD = 77;
    public static final int FIELD_OFFSET_EXTENSION = 0;
    public static final int TYPE_ID = 2;
    private OctetsFW payloadRO = new OctetsFW();
    private final OctetsFW extensionRO = new OctetsFW();

    public long routeId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    public long streamId() {
        return this.buffer().getLong(this.offset() + 8);
    }

    public long sequence() {
        return this.buffer().getLong(this.offset() + 16);
    }

    public long acknowledge() {
        return this.buffer().getLong(this.offset() + 24);
    }

    public int maximum() {
        return this.buffer().getInt(this.offset() + 32);
    }

    public long timestamp() {
        return this.buffer().getLong(this.offset() + 36);
    }

    public long traceId() {
        return this.buffer().getLong(this.offset() + 44);
    }

    public long authorization() {
        return this.buffer().getLong(this.offset() + 52);
    }

    public int flags() {
        return this.buffer().getByte(this.offset() + 60) & 0xFF;
    }

    public long budgetId() {
        return this.buffer().getLong(this.offset() + 61);
    }

    public int reserved() {
        return this.buffer().getInt(this.offset() + 69);
    }

    public int length() {
        return this.buffer().getInt(this.offset() + 73);
    }

    public OctetsFW payload() {
        return this.length() == -1 ? null : this.payloadRO;
    }

    public OctetsFW extension() {
        return this.extensionRO;
    }

    public int typeId() {
        return 2;
    }

    @Override
    public DataFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.payloadRO.wrap(buffer, offset + 77, offset + 77 + (this.length() == -1 ? 0 : this.length()));
        this.extensionRO.wrap(buffer, this.payloadRO.limit() + 0, maxLimit);
        DataFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public DataFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        int limit = offset + 77 + (this.length() == -1 ? 0 : this.length());
        if (limit > maxLimit || null == this.payloadRO.tryWrap(buffer, offset + 77, limit)) {
            return null;
        }
        if (null == this.extensionRO.tryWrap(buffer, this.payloadRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.extensionRO.limit();
    }

    public String toString() {
        return String.format("DATA [routeId=%d, streamId=%d, sequence=%d, acknowledge=%d, maximum=%d, timestamp=%d, traceId=%d, authorization=%d, flags=%d, budgetId=%d, reserved=%d, length=%d, payload=%s, extension=%s]", this.routeId(), this.streamId(), this.sequence(), this.acknowledge(), this.maximum(), this.timestamp(), this.traceId(), this.authorization(), this.flags(), this.budgetId(), this.reserved(), this.length(), this.payload(), this.extension());
    }

    public static final class Builder
    extends Flyweight.Builder<DataFW> {
        private static final int INDEX_ROUTE_ID = 0;
        private static final int INDEX_STREAM_ID = 1;
        private static final int INDEX_SEQUENCE = 2;
        private static final int INDEX_ACKNOWLEDGE = 3;
        private static final int INDEX_MAXIMUM = 4;
        private static final int INDEX_TIMESTAMP = 5;
        public static final long DEFAULT_TIMESTAMP = 0L;
        private static final int INDEX_TRACE_ID = 6;
        public static final long DEFAULT_TRACE_ID = 0L;
        private static final int INDEX_AUTHORIZATION = 7;
        public static final long DEFAULT_AUTHORIZATION = 0L;
        private static final int INDEX_FLAGS = 8;
        public static final int DEFAULT_FLAGS = 3;
        private static final int INDEX_BUDGET_ID = 9;
        private static final int INDEX_RESERVED = 10;
        public static final int DEFAULT_LENGTH = 0;
        private static final int INDEX_PAYLOAD = 11;
        private static final int INDEX_EXTENSION = 12;
        private static final int FIELD_COUNT = 13;
        private int dynamicOffsetLength;
        private final OctetsFW.Builder payloadRW = new OctetsFW.Builder();
        private final OctetsFW.Builder extensionRW = new OctetsFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new DataFW());
        }

        public Builder routeId(long value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 8;
            DataFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder streamId(long value) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 8;
            DataFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        public Builder sequence(long value) {
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + 8;
            DataFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 2;
            this.limit(newLimit);
            return this;
        }

        public Builder acknowledge(long value) {
            assert (this.lastFieldSet == 2);
            int newLimit = this.limit() + 8;
            DataFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 3;
            this.limit(newLimit);
            return this;
        }

        public Builder maximum(int value) {
            assert (this.lastFieldSet == 3);
            int newLimit = this.limit() + 4;
            DataFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 4;
            this.limit(newLimit);
            return this;
        }

        public Builder timestamp(long value) {
            assert (this.lastFieldSet == 4);
            int newLimit = this.limit() + 8;
            DataFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 5;
            this.limit(newLimit);
            return this;
        }

        public Builder traceId(long value) {
            if (this.lastFieldSet < 5) {
                this.timestamp(0L);
            }
            assert (this.lastFieldSet == 5);
            int newLimit = this.limit() + 8;
            DataFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 6;
            this.limit(newLimit);
            return this;
        }

        public Builder authorization(long value) {
            if (this.lastFieldSet < 6) {
                this.traceId(0L);
            }
            assert (this.lastFieldSet == 6);
            int newLimit = this.limit() + 8;
            DataFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 7;
            this.limit(newLimit);
            return this;
        }

        public Builder flags(int value) {
            if (value < 0) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"flags\"", value));
            }
            if (value > 255) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"flags\"", value));
            }
            if (this.lastFieldSet < 7) {
                this.authorization(0L);
            }
            assert (this.lastFieldSet == 7);
            int newLimit = this.limit() + 1;
            DataFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putByte(this.limit(), (byte)(value & 0xFF));
            this.lastFieldSet = 8;
            this.limit(newLimit);
            return this;
        }

        public Builder budgetId(long value) {
            if (this.lastFieldSet < 8) {
                this.flags(3);
            }
            assert (this.lastFieldSet == 8);
            int newLimit = this.limit() + 8;
            DataFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 9;
            this.limit(newLimit);
            return this;
        }

        public Builder reserved(int value) {
            assert (this.lastFieldSet == 9);
            int newLimit = this.limit() + 4;
            DataFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 10;
            this.limit(newLimit);
            return this;
        }

        private Builder length(int value) {
            int newLimit = this.limit() + 4;
            DataFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.dynamicOffsetLength = this.limit();
            this.limit(newLimit);
            return this;
        }

        private OctetsFW.Builder payload() {
            this.length(0);
            assert (this.lastFieldSet == 10);
            return this.payloadRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder payload(OctetsFW value) {
            int newLimit;
            int size$;
            OctetsFW.Builder payloadRW = this.payload();
            if (value == null) {
                size$ = -1;
                newLimit = this.limit();
            } else {
                payloadRW.set(value);
                newLimit = ((OctetsFW)payloadRW.build()).limit();
                size$ = newLimit - this.limit();
            }
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.lastFieldSet = 11;
            return this;
        }

        public Builder payload(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder payloadRW = this.payload();
            mutator.accept(payloadRW);
            int newLimit = ((OctetsFW)payloadRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.lastFieldSet = 11;
            return this;
        }

        public Builder payload(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder payloadRW = this.payload();
            payloadRW.set(buffer, offset, length);
            int newLimit = ((OctetsFW)payloadRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.lastFieldSet = 11;
            return this;
        }

        private OctetsFW.Builder extension() {
            if (this.lastFieldSet < 11) {
                this.payload((OctetsFW.Builder b) -> {});
                int limit = this.limit();
                this.limit(this.dynamicOffsetLength);
                this.length(-1);
                this.limit(limit);
            }
            assert (this.lastFieldSet == 11);
            return this.extensionRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder extension(OctetsFW value) {
            OctetsFW.Builder extensionRW = this.extension();
            extensionRW.set(value);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.lastFieldSet = 12;
            return this;
        }

        public Builder extension(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder extensionRW = this.extension();
            mutator.accept(extensionRW);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.lastFieldSet = 12;
            return this;
        }

        public Builder extension(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder extensionRW = this.extension();
            extensionRW.set(buffer, offset, length);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.lastFieldSet = 12;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.dynamicOffsetLength = -1;
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.dynamicOffsetLength = -1;
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public DataFW build() {
            if (this.lastFieldSet < 12) {
                this.extension((OctetsFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 12);
            this.lastFieldSet = -1;
            return (DataFW)super.build();
        }
    }
}

