/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus;

import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.agrona.BitUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.kaazing.k3po.lang.el.Function;
import org.kaazing.k3po.lang.el.spi.FunctionMapperSpi;
import org.reaktivity.specification.nukleus.internal.types.String16FW;
import org.reaktivity.specification.nukleus.internal.types.String8FW;
import org.reaktivity.specification.nukleus.internal.types.stream.Capability;

public final class CoreFunctions {
    private static final ThreadLocal<String8FW.Builder> STRING_RW = ThreadLocal.withInitial(String8FW.Builder::new);
    private static final ThreadLocal<String16FW.Builder> STRING16_RW = ThreadLocal.withInitial(String16FW.Builder::new);
    private static final ThreadLocal<String16FW.Builder> STRING16N_RW = ThreadLocal.withInitial(() -> new String16FW.Builder(ByteOrder.BIG_ENDIAN));

    @Function
    public static byte[] fromHex(String text) {
        return BitUtil.fromHex((String)text);
    }

    @Function
    public static Random random() {
        return ThreadLocalRandom.current();
    }

    @Function
    public static byte[] string(String text) {
        int capacity = 1 + Optional.ofNullable(text).orElse("").length() * 2 + 1;
        UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[capacity]);
        String8FW string = STRING_RW.get().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity()).set(text, StandardCharsets.UTF_8).build();
        byte[] array = new byte[string.sizeof()];
        string.buffer().getBytes(0, array);
        return array;
    }

    @Function
    public static byte[] string16(String text) {
        int capacity = 2 + Optional.ofNullable(text).orElse("").length() * 2 + 1;
        UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[capacity]);
        String16FW string16 = STRING16_RW.get().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity()).set(text, StandardCharsets.UTF_8).build();
        byte[] array = new byte[string16.sizeof()];
        string16.buffer().getBytes(0, array);
        return array;
    }

    @Function
    public static byte[] string16n(String text) {
        int capacity = 2 + Optional.ofNullable(text).orElse("").length() * 2 + 1;
        UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[capacity]);
        String16FW string16 = STRING16N_RW.get().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity()).set(text, StandardCharsets.UTF_8).build();
        byte[] array = new byte[string16.sizeof()];
        string16.buffer().getBytes(0, array);
        return array;
    }

    @Function
    public static byte[] varstring(String text) {
        byte[] bytes = text != null ? text.getBytes(StandardCharsets.UTF_8) : null;
        return CoreFunctions.varbytes(bytes);
    }

    @Function
    public static byte[] varbytes(byte[] bytes) {
        if (bytes == null) {
            return CoreFunctions.varuintn(-1L);
        }
        byte[] length = CoreFunctions.varuintn(bytes.length);
        byte[] varbytes = new byte[length.length + bytes.length];
        System.arraycopy(length, 0, varbytes, 0, length.length);
        System.arraycopy(bytes, 0, varbytes, length.length, bytes.length);
        return varbytes;
    }

    @Function
    public static byte[] varuintn(long nvalue) {
        return CoreFunctions.varuint(nvalue + 1L);
    }

    @Function
    public static byte[] varuint(long value) {
        return CoreFunctions.varbits(value);
    }

    @Function
    public static byte[] varint(long value) {
        long bits = value << 1 ^ value >> 63;
        return CoreFunctions.varbits(bits);
    }

    private static byte[] varbits(long bits) {
        switch (bits != 0L ? (int)Math.ceil((double)(1 + Long.numberOfTrailingZeros(Long.highestOneBit(bits))) / 7.0) : 1) {
            case 1: {
                return new byte[]{(byte)(bits >> 0 & 0x7FL)};
            }
            case 2: {
                return new byte[]{(byte)(bits >> 0 & 0x7FL | 0x80L), (byte)(bits >> 7 & 0x7FL)};
            }
            case 3: {
                return new byte[]{(byte)(bits >> 0 & 0x7FL | 0x80L), (byte)(bits >> 7 & 0x7FL | 0x80L), (byte)(bits >> 14 & 0x7FL)};
            }
            case 4: {
                return new byte[]{(byte)(bits >> 0 & 0x7FL | 0x80L), (byte)(bits >> 7 & 0x7FL | 0x80L), (byte)(bits >> 14 & 0x7FL | 0x80L), (byte)(bits >> 21 & 0x7FL)};
            }
            case 5: {
                return new byte[]{(byte)(bits >> 0 & 0x7FL | 0x80L), (byte)(bits >> 7 & 0x7FL | 0x80L), (byte)(bits >> 14 & 0x7FL | 0x80L), (byte)(bits >> 21 & 0x7FL | 0x80L), (byte)(bits >> 28 & 0x7FL)};
            }
            case 6: {
                return new byte[]{(byte)(bits >> 0 & 0x7FL | 0x80L), (byte)(bits >> 7 & 0x7FL | 0x80L), (byte)(bits >> 14 & 0x7FL | 0x80L), (byte)(bits >> 21 & 0x7FL | 0x80L), (byte)(bits >> 28 & 0x7FL | 0x80L), (byte)(bits >> 35 & 0x7FL)};
            }
            case 7: {
                return new byte[]{(byte)(bits >> 0 & 0x7FL | 0x80L), (byte)(bits >> 7 & 0x7FL | 0x80L), (byte)(bits >> 14 & 0x7FL | 0x80L), (byte)(bits >> 21 & 0x7FL | 0x80L), (byte)(bits >> 28 & 0x7FL | 0x80L), (byte)(bits >> 35 & 0x7FL | 0x80L), (byte)(bits >> 42 & 0x7FL)};
            }
            case 8: {
                return new byte[]{(byte)(bits >> 0 & 0x7FL | 0x80L), (byte)(bits >> 7 & 0x7FL | 0x80L), (byte)(bits >> 14 & 0x7FL | 0x80L), (byte)(bits >> 21 & 0x7FL | 0x80L), (byte)(bits >> 28 & 0x7FL | 0x80L), (byte)(bits >> 35 & 0x7FL | 0x80L), (byte)(bits >> 42 & 0x7FL | 0x80L), (byte)(bits >> 49 & 0x7FL)};
            }
            case 9: {
                return new byte[]{(byte)(bits >> 0 & 0x7FL | 0x80L), (byte)(bits >> 7 & 0x7FL | 0x80L), (byte)(bits >> 14 & 0x7FL | 0x80L), (byte)(bits >> 21 & 0x7FL | 0x80L), (byte)(bits >> 28 & 0x7FL | 0x80L), (byte)(bits >> 35 & 0x7FL | 0x80L), (byte)(bits >> 42 & 0x7FL | 0x80L), (byte)(bits >> 49 & 0x7FL | 0x80L), (byte)(bits >> 56 & 0x7FL)};
            }
        }
        return new byte[]{(byte)(bits >> 0 & 0x7FL | 0x80L), (byte)(bits >> 7 & 0x7FL | 0x80L), (byte)(bits >> 14 & 0x7FL | 0x80L), (byte)(bits >> 21 & 0x7FL | 0x80L), (byte)(bits >> 28 & 0x7FL | 0x80L), (byte)(bits >> 35 & 0x7FL | 0x80L), (byte)(bits >> 42 & 0x7FL | 0x80L), (byte)(bits >> 49 & 0x7FL | 0x80L), (byte)(bits >> 56 & 0x7FL | 0x80L), (byte)(bits >> 63 & 1L)};
    }

    @Function
    public static byte capabilities(String capability, String ... optionalCapabilities) {
        return CoreFunctions.of(capability, optionalCapabilities);
    }

    private static byte of(String name, String ... optionalNames) {
        byte capabilityMask = 0;
        capabilityMask = (byte)(capabilityMask | 1 << Capability.valueOf(name).ordinal());
        for (int i = 0; i < optionalNames.length; ++i) {
            int capabilityOrdinal = Capability.valueOf(optionalNames[i]).ordinal();
            assert (capabilityOrdinal < 8);
            capabilityMask = (byte)(capabilityMask | 1 << capabilityOrdinal);
        }
        return capabilityMask;
    }

    private CoreFunctions() {
    }

    public static class Mapper
    extends FunctionMapperSpi.Reflective {
        public Mapper() {
            super(CoreFunctions.class);
        }

        public String getPrefixName() {
            return "core";
        }
    }
}

