/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus.control;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.agrona.IoUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.broadcast.BroadcastBufferDescriptor;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;
import org.agrona.concurrent.ringbuffer.RingBufferDescriptor;
import org.kaazing.k3po.lang.el.Function;
import org.kaazing.k3po.lang.el.spi.FunctionMapperSpi;

@Deprecated
public final class Functions {
    private static final int META_DATA_LENGTH = 64;

    @Function
    public static Layout mapNew(String filename, int ringCapacity, int broadcastCapacity) {
        return new EagerLayout(true, new File(filename), ringCapacity, broadcastCapacity);
    }

    @Function
    public static Layout map(String filename, int ringCapacity, int broadcastCapacity) {
        return new DeferredLayout(false, new File(filename), ringCapacity, broadcastCapacity);
    }

    private Functions() {
    }

    public static final class EagerLayout
    extends Layout {
        private final MappedByteBuffer buffer;
        private final AtomicBuffer nukleus;
        private final AtomicBuffer controller;

        public EagerLayout(boolean overwrite, File location, int ringCapacity, int broadcastCapacity) {
            File absolute = location.getAbsoluteFile();
            int metaLength = 64;
            int ringLength = ringCapacity + RingBufferDescriptor.TRAILER_LENGTH;
            int broadcastLength = broadcastCapacity + BroadcastBufferDescriptor.TRAILER_LENGTH;
            this.buffer = overwrite ? IoUtil.mapNewFile((File)absolute, (long)(metaLength + ringLength + broadcastLength)) : IoUtil.mapExistingFile((File)absolute, (String)location.getAbsolutePath());
            this.nukleus = new UnsafeBuffer((ByteBuffer)this.buffer, metaLength, ringLength);
            this.controller = new UnsafeBuffer((ByteBuffer)this.buffer, metaLength + ringLength, broadcastLength);
        }

        @Override
        public AtomicBuffer getNukleus() {
            return this.nukleus;
        }

        @Override
        public AtomicBuffer getController() {
            return this.controller;
        }

        @Override
        public void close() {
            IoUtil.unmap((MappedByteBuffer)this.buffer);
        }
    }

    public static final class DeferredLayout
    extends Layout {
        private final boolean overwrite;
        private final File location;
        private final int ringCapacity;
        private final int broadcastCapacity;
        private EagerLayout delegate;

        public DeferredLayout(boolean overwrite, File location, int ringCapacity, int broadcastCapacity) {
            this.overwrite = overwrite;
            this.location = location;
            this.ringCapacity = ringCapacity;
            this.broadcastCapacity = broadcastCapacity;
        }

        @Override
        public AtomicBuffer getNukleus() {
            this.ensureInitialized();
            return this.delegate.nukleus;
        }

        @Override
        public AtomicBuffer getController() {
            this.ensureInitialized();
            return this.delegate.controller;
        }

        @Override
        public void close() throws Exception {
            if (this.delegate != null) {
                this.delegate.close();
            }
        }

        public String toString() {
            return String.format("Layout [%s]", this.location);
        }

        void ensureInitialized() {
            if (this.delegate == null) {
                this.delegate = new EagerLayout(this.overwrite, this.location, this.ringCapacity, this.broadcastCapacity);
            }
        }
    }

    public static class Mapper
    extends FunctionMapperSpi.Reflective {
        public Mapper() {
            super(Functions.class);
        }

        public String getPrefixName() {
            return "control";
        }
    }

    private static abstract class Layout
    implements AutoCloseable {
        private long correlationId;

        private Layout() {
        }

        public abstract AtomicBuffer getNukleus();

        public abstract AtomicBuffer getController();

        public final long nextCorrelationId() {
            ManyToOneRingBuffer ring = new ManyToOneRingBuffer(this.getNukleus());
            this.correlationId = ring.nextCorrelationId();
            return this.correlationId;
        }

        public final long correlationId() {
            return this.correlationId;
        }
    }
}

