/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus.internal.types;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.specification.nukleus.internal.types.Flyweight;
import org.reaktivity.specification.nukleus.internal.types.ListFW;

public final class List32FW
extends ListFW {
    private static final int LENGTH_SIZE = 4;
    private static final int FIELD_COUNT_SIZE = 4;
    private static final int LENGTH_OFFSET = 0;
    private static final int FIELD_COUNT_OFFSET = 4;
    private static final int FIELDS_OFFSET = 8;
    private final DirectBuffer fieldsRO = new UnsafeBuffer(0L, 0);
    private final ByteOrder byteOrder;

    public List32FW() {
        this.byteOrder = ByteOrder.nativeOrder();
    }

    public List32FW(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    @Override
    public int limit() {
        return this.offset() + 4 + this.length();
    }

    @Override
    public int length() {
        return this.buffer().getInt(this.offset() + 0, this.byteOrder);
    }

    @Override
    public int fieldCount() {
        return this.buffer().getInt(this.offset() + 4, this.byteOrder);
    }

    @Override
    public DirectBuffer fields() {
        return this.fieldsRO;
    }

    @Override
    public List32FW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        int fieldsSize = this.length() - 4;
        this.fieldsRO.wrap(buffer, offset + 8, fieldsSize);
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public List32FW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        int fieldsSize = this.length() - 4;
        this.fieldsRO.wrap(buffer, offset + 8, fieldsSize);
        List32FW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    public String toString() {
        return String.format("list32<%d, %d>", this.length(), this.fieldCount());
    }

    public static final class Builder
    extends ListFW.Builder<List32FW> {
        private final ByteOrder byteOrder;
        private int fieldCount;

        public Builder() {
            super(new List32FW());
            this.byteOrder = ByteOrder.nativeOrder();
        }

        public Builder(ByteOrder byteOrder) {
            super(new List32FW(byteOrder));
            this.byteOrder = byteOrder;
        }

        public Builder field(Flyweight.Builder.Visitor visitor) {
            int length = visitor.visit(this.buffer(), this.limit(), this.maxLimit());
            ++this.fieldCount;
            int newLimit = this.limit() + length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.limit(newLimit);
            return this;
        }

        public Builder fields(int fieldCount, Flyweight.Builder.Visitor visitor) {
            int length = visitor.visit(this.buffer(), this.limit(), this.maxLimit());
            this.fieldCount += fieldCount;
            int newLimit = this.limit() + length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.limit(newLimit);
            return this;
        }

        public Builder fields(int fieldCount, DirectBuffer buffer, int index, int length) {
            this.fieldCount += fieldCount;
            int newLimit = this.limit() + length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), buffer, index, length);
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            int newLimit = offset + 8;
            Flyweight.checkLimit(newLimit, maxLimit);
            this.limit(newLimit);
            this.fieldCount = 0;
            return this;
        }

        @Override
        public List32FW build() {
            this.buffer().putInt(this.offset() + 0, this.limit() - this.offset() - 4, this.byteOrder);
            this.buffer().putInt(this.offset() + 4, this.fieldCount, this.byteOrder);
            return (List32FW)super.build();
        }
    }
}

