/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus.internal.types;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.specification.nukleus.internal.types.Flyweight;
import org.reaktivity.specification.nukleus.internal.types.ListFW;

public final class List8FW
extends ListFW {
    private static final int LENGTH_SIZE = 1;
    private static final int FIELD_COUNT_SIZE = 1;
    private static final int LENGTH_OFFSET = 0;
    private static final int FIELD_COUNT_OFFSET = 1;
    private static final int FIELDS_OFFSET = 2;
    private static final int LENGTH_MAX_VALUE = 255;
    private final DirectBuffer fieldsRO = new UnsafeBuffer(0L, 0);

    @Override
    public int limit() {
        return this.offset() + 1 + this.length();
    }

    @Override
    public int length() {
        return this.buffer().getByte(this.offset() + 0) & 0xFF;
    }

    @Override
    public int fieldCount() {
        return this.buffer().getByte(this.offset() + 1) & 0xFF;
    }

    @Override
    public DirectBuffer fields() {
        return this.fieldsRO;
    }

    @Override
    public List8FW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        int fieldsSize = this.length() - 1;
        this.fieldsRO.wrap(buffer, offset + 2, fieldsSize);
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public List8FW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        int fieldsSize = this.length() - 1;
        this.fieldsRO.wrap(buffer, offset + 2, fieldsSize);
        List8FW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    public String toString() {
        return String.format("list8<%d, %d>", this.length(), this.fieldCount());
    }

    public static final class Builder
    extends ListFW.Builder<List8FW> {
        private int fieldCount;

        public Builder() {
            super(new List8FW());
        }

        public Builder field(Flyweight.Builder.Visitor visitor) {
            int length = visitor.visit(this.buffer(), this.limit(), this.maxLimit());
            ++this.fieldCount;
            int newLimit = this.limit() + length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.limit(newLimit);
            return this;
        }

        public Builder fields(int fieldCount, Flyweight.Builder.Visitor visitor) {
            int length = visitor.visit(this.buffer(), this.limit(), this.maxLimit());
            this.fieldCount += fieldCount;
            int newLimit = this.limit() + length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.limit(newLimit);
            return this;
        }

        public Builder fields(int fieldCount, DirectBuffer buffer, int index, int length) {
            this.fieldCount += fieldCount;
            int newLimit = this.limit() + length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), buffer, index, length);
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            int newLimit = offset + 2;
            Flyweight.checkLimit(newLimit, maxLimit);
            this.limit(newLimit);
            this.fieldCount = 0;
            return this;
        }

        @Override
        public List8FW build() {
            int length = this.limit() - this.offset() - 1;
            assert (length <= 255) : "Length is too large";
            assert (this.fieldCount <= 255) : "Field count is too large";
            this.buffer().putByte(this.offset() + 0, (byte)length);
            this.buffer().putByte(this.offset() + 1, (byte)this.fieldCount);
            return (List8FW)super.build();
        }
    }
}

