/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus.internal.types;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.specification.nukleus.internal.types.Flyweight;
import org.reaktivity.specification.nukleus.internal.types.StringFW;
import org.reaktivity.specification.nukleus.internal.types.Varuint32nFW;

public final class VarStringFW
extends StringFW {
    private static final int FIELD_MAX_SIZE_LENGTH = 5;
    private final Varuint32nFW lengthRO = new Varuint32nFW();
    private final DirectBuffer valueRO = new UnsafeBuffer(0L, 0);

    public VarStringFW() {
    }

    public VarStringFW(String value) {
        this(value, StandardCharsets.UTF_8);
    }

    public VarStringFW(String value, Charset charset) {
        byte[] encoded = value != null ? value.getBytes(charset) : null;
        int encodedSize = encoded != null ? encoded.length : 1;
        UnsafeBuffer buffer = new UnsafeBuffer(new byte[5 + encodedSize]);
        new Builder().wrap((MutableDirectBuffer)buffer, 0, buffer.capacity()).set(value, charset).build();
    }

    @Override
    public int fieldSizeLength() {
        return this.lengthRO.sizeof();
    }

    @Override
    public int limit() {
        return this.lengthRO.limit() + Math.max(this.length(), 0);
    }

    public DirectBuffer value() {
        return this.length() == -1 ? null : this.valueRO;
    }

    @Override
    public String asString() {
        if (this.maxLimit() == this.offset() || this.length() == -1) {
            return null;
        }
        return this.buffer().getStringWithoutLengthUtf8(this.lengthRO.limit(), this.length());
    }

    @Override
    public VarStringFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit) || null == this.lengthRO.tryWrap(buffer, offset, maxLimit) || this.limit() > maxLimit) {
            return null;
        }
        int length = this.length();
        if (length != -1) {
            this.valueRO.wrap(buffer, this.lengthRO.limit(), length);
        }
        return this;
    }

    @Override
    public VarStringFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.lengthRO.wrap(buffer, offset, maxLimit);
        VarStringFW.checkLimit(this.limit(), maxLimit);
        int length = this.length();
        if (length != -1) {
            this.valueRO.wrap(buffer, this.lengthRO.limit(), length);
        }
        return this;
    }

    public String toString() {
        return this.maxLimit() == this.offset() ? "null" : String.format("\"%s\"", this.asString());
    }

    @Override
    public int length() {
        int length = this.lengthRO.value();
        return length < 0 ? -1 : length;
    }

    public static final class Builder
    extends StringFW.Builder<VarStringFW> {
        private Varuint32nFW.Builder lengthRW = new Varuint32nFW.Builder();
        private boolean valueSet;

        public Builder() {
            super(new VarStringFW());
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            Flyweight.checkLimit(offset + 1, maxLimit);
            super.wrap(buffer, offset, maxLimit);
            this.lengthRW.wrap(buffer, offset, maxLimit);
            this.valueSet = false;
            return this;
        }

        public Builder set(StringFW value) {
            int len = value.length();
            if (len == -1) {
                this.limit(this.lengthRW.set(-1).build().limit());
            } else {
                Varuint32nFW length = this.lengthRW.set(len).build();
                int newLimit = length.limit() + length.value();
                Flyweight.checkLimit(newLimit, this.maxLimit());
                this.buffer().putBytes(length.limit(), value.buffer(), value.offset() + value.fieldSizeLength(), len);
                this.limit(newLimit);
            }
            this.valueSet = true;
            return this;
        }

        public Builder set(DirectBuffer srcBuffer, int srcOffset, int srcLength) {
            Builder.checkLength(srcLength);
            Varuint32nFW length = this.lengthRW.set(srcLength).build();
            int newLimit = length.limit() + length.value();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(length.limit(), srcBuffer, srcOffset, srcLength);
            this.limit(newLimit);
            this.valueSet = true;
            return this;
        }

        public Builder set(String value, Charset charset) {
            if (value == null) {
                this.limit(this.lengthRW.set(-1).build().limit());
            } else {
                byte[] charBytes = value.getBytes(charset);
                Builder.checkLength(charBytes.length);
                Varuint32nFW length = this.lengthRW.set(charBytes.length).build();
                int newLimit = length.limit() + length.value();
                Flyweight.checkLimit(newLimit, this.maxLimit());
                this.buffer().putBytes(length.limit(), charBytes);
                this.limit(newLimit);
            }
            this.valueSet = true;
            return this;
        }

        private static void checkLength(int length) {
            int maxLength = 0x7FFFFFFE;
            if (length > 0x7FFFFFFE) {
                String msg = String.format("length=%d is beyond maximum length=%d", length, 0x7FFFFFFE);
                throw new IllegalArgumentException(msg);
            }
        }

        @Override
        public VarStringFW build() {
            if (!this.valueSet) {
                this.set(null, StandardCharsets.UTF_8);
            }
            return (VarStringFW)super.build();
        }
    }
}

