/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus.internal.types;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.nukleus.internal.types.Flyweight;

public final class Varuint32nFW
extends Flyweight {
    private int size;

    @Override
    public int limit() {
        return this.offset() + this.size;
    }

    public int value() {
        DirectBuffer buffer = this.buffer();
        int offset = this.offset();
        int limit = this.limit();
        int value = 0;
        int progress = offset;
        if (progress < limit) {
            byte bits;
            int shift = 0;
            do {
                bits = buffer.getByte(progress);
                value |= (bits & 0x7F) << shift;
                shift += 7;
            } while (++progress < limit && (bits & 0x80) != 0);
        }
        return value - 1;
    }

    @Override
    public Varuint32nFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit) || maxLimit - offset < 1) {
            return null;
        }
        this.size = this.length0();
        if (this.size < 0 || this.size > 5 || this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public Varuint32nFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        Varuint32nFW.checkLimit(offset + 1, maxLimit);
        this.size = this.length0();
        if (this.size < 0 || this.size > 5) {
            throw new IllegalArgumentException(String.format("varuint32 value at offset %d exceeds 32 bits", offset));
        }
        Varuint32nFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    public String toString() {
        return Integer.toString(this.value());
    }

    private int length0() {
        DirectBuffer buffer = this.buffer();
        int offset = this.offset();
        int maxPos = Math.min(offset + 5, this.maxLimit());
        int index = 0;
        while (index + offset < maxPos && (buffer.getByte(index + offset) & 0x80) != 0) {
            ++index;
        }
        int size = 1 + index;
        return size;
    }

    public static final class Builder
    extends Flyweight.Builder<Varuint32nFW> {
        private boolean valueSet;

        public Builder() {
            super(new Varuint32nFW());
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            Flyweight.checkLimit(offset + 1, maxLimit);
            super.wrap(buffer, offset, maxLimit);
            this.valueSet = false;
            return this;
        }

        public Builder set(int nvalue) {
            if (nvalue < -1 || nvalue > 0xFFFFFFF) {
                throw new IllegalArgumentException(String.format("Input value %d out of range", nvalue));
            }
            MutableDirectBuffer buffer = this.buffer();
            int value = nvalue + 1;
            int progress = this.offset();
            do {
                int bits = value & 0x7F;
                if ((value >>= 7) != 0) {
                    bits |= 0x80;
                }
                buffer.putByte(progress++, (byte)(bits & 0xFF));
            } while (value > 0);
            int newLimit = progress;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.limit(newLimit);
            this.valueSet = true;
            return this;
        }

        @Override
        public Varuint32nFW build() {
            if (!this.valueSet) {
                throw new IllegalArgumentException("value not set");
            }
            return (Varuint32nFW)super.build();
        }
    }
}

