/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import org.reaktivity.nukleus.Configuration;
import org.reaktivity.nukleus.Controller;
import org.reaktivity.nukleus.ControllerBuilder;
import org.reaktivity.nukleus.ControllerFactorySpi;

public final class ControllerFactory {
    private final Map<Class<? extends Controller>, ControllerFactorySpi> factorySpisByKind;

    public static ControllerFactory instantiate() {
        return ControllerFactory.instantiate(ServiceLoader.load(ControllerFactorySpi.class));
    }

    public static ControllerFactory instantiate(ClassLoader classLoader) {
        return ControllerFactory.instantiate(ServiceLoader.load(ControllerFactorySpi.class, classLoader));
    }

    public Iterable<? extends Class<? extends Controller>> kinds() {
        return this.factorySpisByKind.keySet();
    }

    public <T extends Controller> String name(Class<T> kind) {
        Objects.requireNonNull(kind, "kind");
        ControllerFactorySpi factorySpi = this.factorySpisByKind.get(kind);
        if (factorySpi == null) {
            throw new IllegalArgumentException("Unregonized controller kind: " + kind.getName());
        }
        return factorySpi.name();
    }

    public <T extends Controller> T create(Configuration config, ControllerBuilder<T> builder) {
        Objects.requireNonNull(config, "config");
        Objects.requireNonNull(builder, "builder");
        Class<T> kind = builder.kind();
        ControllerFactorySpi factorySpi = this.factorySpisByKind.get(kind);
        if (factorySpi == null) {
            throw new IllegalArgumentException("Unregonized controller kind: " + kind.getName());
        }
        return factorySpi.create(config, builder);
    }

    private static ControllerFactory instantiate(ServiceLoader<ControllerFactorySpi> factories) {
        HashMap factorySpisByName = new HashMap();
        factories.forEach(factorySpi -> factorySpisByName.put(factorySpi.kind(), factorySpi));
        return new ControllerFactory(Collections.unmodifiableMap(factorySpisByName));
    }

    private ControllerFactory(Map<Class<? extends Controller>, ControllerFactorySpi> factorySpisByName) {
        this.factorySpisByKind = factorySpisByName;
    }
}

