/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.test.internal.k3po.ext.behavior;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.netty.channel.ChannelHandler;
import org.kaazing.k3po.driver.internal.behavior.BehaviorSystemSpi;
import org.kaazing.k3po.driver.internal.behavior.ReadConfigFactory;
import org.kaazing.k3po.driver.internal.behavior.ReadOptionFactory;
import org.kaazing.k3po.driver.internal.behavior.WriteConfigFactory;
import org.kaazing.k3po.driver.internal.behavior.WriteOptionFactory;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.ConfigEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageDecoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.command.WriteConfigHandler;
import org.kaazing.k3po.lang.internal.RegionInfo;
import org.kaazing.k3po.lang.internal.ast.AstReadConfigNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteConfigNode;
import org.kaazing.k3po.lang.internal.ast.matcher.AstValueMatcher;
import org.kaazing.k3po.lang.internal.ast.value.AstValue;
import org.kaazing.k3po.lang.types.StructuredTypeInfo;
import org.kaazing.k3po.lang.types.TypeInfo;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusExtensionKind;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.config.NukleusExtensionDecoder;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.config.NukleusExtensionEncoder;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.config.ReadBeginExtHandler;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.config.ReadChallengeHandler;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.config.ReadDataExtHandler;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.config.ReadEndExtHandler;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.config.ReadNullDataHandler;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.config.WriteChallengeHandler;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.config.WriteEmptyDataHandler;
import org.reaktivity.reaktor.test.internal.k3po.ext.types.NukleusTypeSystem;

public class NukleusBehaviorSystem
implements BehaviorSystemSpi {
    private final Map<TypeInfo<?>, ReadOptionFactory> readOptionFactories = Collections.emptyMap();
    private final Map<TypeInfo<?>, WriteOptionFactory> writeOptionFactories = Collections.emptyMap();
    private final Map<StructuredTypeInfo, ReadConfigFactory> readConfigFactories;
    private final Map<StructuredTypeInfo, WriteConfigFactory> writeConfigFactories;

    public NukleusBehaviorSystem() {
        LinkedHashMap<StructuredTypeInfo, ReadConfigFactory> readConfigFactories = new LinkedHashMap<StructuredTypeInfo, ReadConfigFactory>();
        readConfigFactories.put(NukleusTypeSystem.CONFIG_BEGIN_EXT, NukleusBehaviorSystem::newReadBeginExtHandler);
        readConfigFactories.put(NukleusTypeSystem.CONFIG_DATA_EXT, NukleusBehaviorSystem::newReadDataExtHandler);
        readConfigFactories.put(NukleusTypeSystem.CONFIG_DATA_NULL, NukleusBehaviorSystem::newReadNullDataHandler);
        readConfigFactories.put(NukleusTypeSystem.CONFIG_END_EXT, NukleusBehaviorSystem::newReadEndExtHandler);
        readConfigFactories.put(NukleusTypeSystem.CONFIG_CHALLENGE, NukleusBehaviorSystem::newReadChallengeHandler);
        this.readConfigFactories = Collections.unmodifiableMap(readConfigFactories);
        LinkedHashMap<StructuredTypeInfo, WriteConfigFactory> writeConfigFactories = new LinkedHashMap<StructuredTypeInfo, WriteConfigFactory>();
        writeConfigFactories.put(NukleusTypeSystem.CONFIG_BEGIN_EXT, NukleusBehaviorSystem::newWriteBeginExtHandler);
        writeConfigFactories.put(NukleusTypeSystem.CONFIG_DATA_EMPTY, NukleusBehaviorSystem::newWriteEmptyDataHandler);
        writeConfigFactories.put(NukleusTypeSystem.CONFIG_DATA_EXT, NukleusBehaviorSystem::newWriteDataExtHandler);
        writeConfigFactories.put(NukleusTypeSystem.CONFIG_END_EXT, NukleusBehaviorSystem::newWriteEndExtHandler);
        writeConfigFactories.put(NukleusTypeSystem.CONFIG_CHALLENGE, NukleusBehaviorSystem::newWriteChallengeHandler);
        this.writeConfigFactories = Collections.unmodifiableMap(writeConfigFactories);
    }

    public Set<StructuredTypeInfo> getReadConfigTypes() {
        return this.readConfigFactories.keySet();
    }

    public Set<StructuredTypeInfo> getWriteConfigTypes() {
        return this.writeConfigFactories.keySet();
    }

    public ReadConfigFactory readConfigFactory(StructuredTypeInfo configType) {
        return this.readConfigFactories.get(configType);
    }

    public WriteConfigFactory writeConfigFactory(StructuredTypeInfo configType) {
        return this.writeConfigFactories.get(configType);
    }

    public Set<TypeInfo<?>> getReadOptionTypes() {
        return this.readOptionFactories.keySet();
    }

    public Set<TypeInfo<?>> getWriteOptionTypes() {
        return this.writeOptionFactories.keySet();
    }

    public ReadOptionFactory readOptionFactory(TypeInfo<?> optionType) {
        return this.readOptionFactories.get(optionType);
    }

    public WriteOptionFactory writeOptionFactory(TypeInfo<?> optionType) {
        return this.writeOptionFactories.get(optionType);
    }

    private static ReadBeginExtHandler newReadBeginExtHandler(AstReadConfigNode node, Function<AstValueMatcher, MessageDecoder> decoderFactory) {
        RegionInfo regionInfo = node.getRegionInfo();
        StructuredTypeInfo type = node.getType();
        List<MessageDecoder> decoders = node.getMatchers().stream().map(decoderFactory).collect(Collectors.toList());
        ReadBeginExtHandler handler = new ReadBeginExtHandler(new NukleusExtensionDecoder(NukleusExtensionKind.BEGIN, type, decoders));
        handler.setRegionInfo(regionInfo);
        return handler;
    }

    private static ReadDataExtHandler newReadDataExtHandler(AstReadConfigNode node, Function<AstValueMatcher, MessageDecoder> decoderFactory) {
        RegionInfo regionInfo = node.getRegionInfo();
        StructuredTypeInfo type = node.getType();
        List<MessageDecoder> decoders = node.getMatchers().stream().map(decoderFactory).collect(Collectors.toList());
        ReadDataExtHandler handler = new ReadDataExtHandler(new NukleusExtensionDecoder(NukleusExtensionKind.DATA, type, decoders));
        handler.setRegionInfo(regionInfo);
        return handler;
    }

    private static ChannelHandler newReadNullDataHandler(AstReadConfigNode node, Function<AstValueMatcher, MessageDecoder> decoderFactory) {
        RegionInfo regionInfo = node.getRegionInfo();
        ReadNullDataHandler handler = new ReadNullDataHandler();
        handler.setRegionInfo(regionInfo);
        return handler;
    }

    private static ReadEndExtHandler newReadEndExtHandler(AstReadConfigNode node, Function<AstValueMatcher, MessageDecoder> decoderFactory) {
        RegionInfo regionInfo = node.getRegionInfo();
        StructuredTypeInfo type = node.getType();
        List<MessageDecoder> decoders = node.getMatchers().stream().map(decoderFactory).collect(Collectors.toList());
        ReadEndExtHandler handler = new ReadEndExtHandler(new NukleusExtensionDecoder(NukleusExtensionKind.END, type, decoders));
        handler.setRegionInfo(regionInfo);
        return handler;
    }

    private static ReadChallengeHandler newReadChallengeHandler(AstReadConfigNode node, Function<AstValueMatcher, MessageDecoder> decoderFactory) {
        RegionInfo regionInfo = node.getRegionInfo();
        StructuredTypeInfo type = node.getType();
        List<MessageDecoder> decoders = node.getMatchers().stream().map(decoderFactory).collect(Collectors.toList());
        ReadChallengeHandler handler = new ReadChallengeHandler(new NukleusExtensionDecoder(NukleusExtensionKind.CHALLENGE, type, decoders));
        handler.setRegionInfo(regionInfo);
        return handler;
    }

    private static WriteConfigHandler newWriteBeginExtHandler(AstWriteConfigNode node, Function<AstValue<?>, MessageEncoder> encoderFactory) {
        StructuredTypeInfo type = node.getType();
        List<MessageEncoder> encoders = node.getValues().stream().map(encoderFactory).collect(Collectors.toList());
        WriteConfigHandler handler = new WriteConfigHandler((ConfigEncoder)new NukleusExtensionEncoder(NukleusExtensionKind.BEGIN, type, encoders));
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static WriteConfigHandler newWriteDataExtHandler(AstWriteConfigNode node, Function<AstValue<?>, MessageEncoder> encoderFactory) {
        StructuredTypeInfo type = node.getType();
        List<MessageEncoder> encoders = node.getValues().stream().map(encoderFactory).collect(Collectors.toList());
        WriteConfigHandler handler = new WriteConfigHandler((ConfigEncoder)new NukleusExtensionEncoder(NukleusExtensionKind.DATA, type, encoders));
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static WriteEmptyDataHandler newWriteEmptyDataHandler(AstWriteConfigNode node, Function<AstValue<?>, MessageEncoder> encoderFactory) {
        WriteEmptyDataHandler handler = new WriteEmptyDataHandler();
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static WriteConfigHandler newWriteEndExtHandler(AstWriteConfigNode node, Function<AstValue<?>, MessageEncoder> encoderFactory) {
        StructuredTypeInfo type = node.getType();
        List<MessageEncoder> encoders = node.getValues().stream().map(encoderFactory).collect(Collectors.toList());
        WriteConfigHandler handler = new WriteConfigHandler((ConfigEncoder)new NukleusExtensionEncoder(NukleusExtensionKind.END, type, encoders));
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static WriteChallengeHandler newWriteChallengeHandler(AstWriteConfigNode node, Function<AstValue<?>, MessageEncoder> encoderFactory) {
        StructuredTypeInfo type = node.getType();
        List<MessageEncoder> encoders = node.getValues().stream().map(encoderFactory).collect(Collectors.toList());
        WriteChallengeHandler handler = new WriteChallengeHandler(new NukleusExtensionEncoder(NukleusExtensionKind.CHALLENGE, type, encoders));
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }
}

