/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.test.internal.k3po.ext.behavior;

import java.util.Deque;
import java.util.LinkedList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelConfig;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.ServerChannel;
import org.kaazing.k3po.driver.internal.netty.bootstrap.channel.AbstractChannel;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;
import org.kaazing.k3po.driver.internal.netty.channel.Channels;
import org.reaktivity.reaktor.internal.budget.DefaultBudgetCreditor;
import org.reaktivity.reaktor.internal.budget.DefaultBudgetDebitor;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.DefaultNukleusChannelConfig;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusByteOrder;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusChannelAddress;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusChannelConfig;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusExtensionKind;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusReaktor;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusServerChannel;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusThrottleMode;
import org.reaktivity.reaktor.test.internal.k3po.ext.types.control.Capability;

public abstract class NukleusChannel
extends AbstractChannel<NukleusChannelConfig> {
    static final ChannelBufferFactory NATIVE_BUFFER_FACTORY = NukleusByteOrder.NATIVE.toBufferFactory();
    private long routeId;
    private int readableBudget;
    private int writableBudget;
    int writablePadding;
    private int writableMinimum;
    private int writtenBytes;
    private int acknowledgedBytes;
    private long sourceId;
    private long sourceAuth;
    private long targetId;
    private long targetAuth;
    private int acknowlegedBytesCheckpoint = -1;
    final NukleusReaktor reaktor;
    final Deque<MessageEvent> writeRequests;
    private NukleusExtensionKind readExtKind;
    private ChannelBuffer readExtBuffer;
    private NukleusExtensionKind writeExtKind;
    private ChannelBuffer writeExtBuffer;
    private boolean targetWriteRequestInProgress;
    private ChannelFuture beginOutputFuture;
    private ChannelFuture beginInputFuture;
    private int capabilities;
    private boolean flushable;
    private DefaultBudgetDebitor debitor;
    private long debitorIndex = -1L;
    private DefaultBudgetCreditor creditor;
    private long creditorIndex = -1L;
    private long debitorId;
    private long creditorId;
    private int pendingSharedBudget;

    NukleusChannel(NukleusServerChannel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, NukleusReaktor reaktor, long targetId) {
        super((ServerChannel)parent, factory, pipeline, sink, (ChannelConfig)new DefaultNukleusChannelConfig());
        this.reaktor = reaktor;
        this.writeRequests = new LinkedList<MessageEvent>();
        this.routeId = -1L;
        this.targetId = targetId;
    }

    public NukleusChannelAddress getLocalAddress() {
        return (NukleusChannelAddress)super.getLocalAddress();
    }

    public NukleusChannelAddress getRemoteAddress() {
        return (NukleusChannelAddress)super.getRemoteAddress();
    }

    public int getLocalScope() {
        return 63;
    }

    public abstract int getRemoteScope();

    protected void setBound() {
        super.setBound();
    }

    protected void setConnected() {
        super.setConnected();
    }

    protected boolean isReadAborted() {
        return super.isReadAborted();
    }

    protected boolean isWriteAborted() {
        return super.isWriteAborted();
    }

    protected boolean isReadClosed() {
        return super.isReadClosed();
    }

    protected boolean isWriteClosed() {
        return super.isWriteClosed();
    }

    protected boolean setReadClosed() {
        return super.setReadClosed();
    }

    protected boolean setWriteClosed() {
        return super.setWriteClosed();
    }

    protected boolean setReadAborted() {
        return super.setReadAborted();
    }

    protected boolean setWriteAborted() {
        return super.setWriteAborted();
    }

    protected boolean setClosed() {
        return super.setClosed();
    }

    protected void setRemoteAddress(ChannelAddress remoteAddress) {
        super.setRemoteAddress(remoteAddress);
    }

    protected void setLocalAddress(ChannelAddress localAddress) {
        super.setLocalAddress(localAddress);
    }

    public String toString() {
        NukleusChannelAddress localAddress = this.getLocalAddress();
        String description = localAddress != null ? localAddress.toString() : super.toString();
        return String.format("%s [sourceId=%d, targetId=%d]", description, this.sourceId, this.targetId);
    }

    public void readableBytes(int credit) {
        this.readableBudget += credit;
        assert (this.readableBudget >= 0);
    }

    public int readableBytes() {
        return Math.max(this.readableBudget - ((NukleusChannelConfig)this.getConfig()).getPadding(), 0);
    }

    public void routeId(long routeId) {
        this.routeId = routeId;
    }

    public long routeId() {
        return this.routeId;
    }

    public void sourceId(long sourceId) {
        this.sourceId = sourceId;
    }

    public long sourceId() {
        return this.sourceId;
    }

    public long targetId() {
        return this.targetId;
    }

    public void sourceAuth(long sourceAuth) {
        this.sourceAuth = sourceAuth;
    }

    public long sourceAuth() {
        return this.sourceAuth;
    }

    public void targetAuth(long targetAuth) {
        this.targetAuth = targetAuth;
    }

    public long targetAuth() {
        return this.targetAuth;
    }

    public ChannelFuture beginOutputFuture() {
        if (this.beginOutputFuture == null) {
            this.beginOutputFuture = org.jboss.netty.channel.Channels.future((Channel)this);
        }
        return this.beginOutputFuture;
    }

    public ChannelFuture beginInputFuture() {
        if (this.beginInputFuture == null) {
            this.beginInputFuture = org.jboss.netty.channel.Channels.future((Channel)this);
        }
        return this.beginInputFuture;
    }

    public void setCreditor(DefaultBudgetCreditor creditor, long creditorId) {
        assert (this.creditor == null);
        this.creditor = creditor;
        this.creditorId = creditorId;
    }

    public void setCreditorIndex(long creditorIndex) {
        assert (creditorIndex != -1L);
        this.creditorIndex = creditorIndex;
        this.getCloseFuture().addListener(this::cleanupCreditor);
    }

    public void doSharedCredit(long traceId, int credit) {
        if (this.creditor != null && this.creditorId != 0L) {
            this.creditor.creditById(traceId, this.creditorId, (long)credit);
        }
    }

    public int pendingSharedBudget() {
        return this.pendingSharedBudget;
    }

    public void pendingSharedCredit(int pendingSharedCredit) {
        if (this.creditorId != 0L) {
            this.pendingSharedBudget += pendingSharedCredit;
        }
    }

    public void setDebitor(DefaultBudgetDebitor debitor, long debitorId) {
        assert (this.debitor == null);
        this.debitor = debitor;
        this.debitorId = debitorId;
        this.debitorIndex = debitor.acquire(debitorId, this.targetId, this::flush);
        if (this.debitorIndex == -1L) {
            this.getCloseFuture().setFailure((Throwable)new ChannelException("Unable to acquire debitor"));
        } else {
            assert (this.debitorIndex != -1L);
            this.getCloseFuture().addListener(this::cleanupDebitor);
        }
    }

    public boolean hasDebitor() {
        return this.debitor != null;
    }

    public long debitorId() {
        return this.debitorId;
    }

    public long creditorId() {
        return this.creditorId;
    }

    private void flush(long budgetId) {
        Channels.flush((Channel)this);
    }

    public int writableBytes() {
        return Math.max(this.writableBudget - this.writablePadding, 0);
    }

    public boolean writable() {
        int writableBudget = this.writableBudget;
        if (this.debitor != null && this.debitorIndex != -1L) {
            writableBudget = Math.min(writableBudget, (int)this.debitor.available(this.debitorIndex));
        }
        return writableBudget > this.writablePadding || !((NukleusChannelConfig)this.getConfig()).hasThrottle();
    }

    public int reservedBytes(int writableBytes) {
        int reservedBytes = writableBytes != 0 ? Math.max(writableBytes + this.writablePadding, this.writableMinimum) : 0;
        boolean hasThrottle = ((NukleusChannelConfig)this.getConfig()).hasThrottle();
        if (hasThrottle) {
            writableBytes = Math.min(this.writableBytes(), writableBytes);
            int n = reservedBytes = writableBytes != 0 ? Math.max(writableBytes + this.writablePadding, this.writableMinimum) : 0;
            if (writableBytes > 0 && this.debitor != null && this.debitorIndex != -1L) {
                reservedBytes = this.debitor.claim(this.debitorIndex, this.targetId, reservedBytes, reservedBytes);
            }
        }
        return reservedBytes;
    }

    public void writtenBytes(int writtenBytes, int reservedBytes) {
        this.writtenBytes += writtenBytes;
        this.writableBudget -= reservedBytes;
        assert (!(this.writablePadding < 0 || this.writableBudget < 0 && ((NukleusChannelConfig)this.getConfig()).hasThrottle()));
    }

    public void writableWindow(int credit, int padding, int minimum, long traceId) {
        this.writableBudget += credit;
        this.writablePadding = padding;
        this.writableMinimum = minimum;
        if (this.writtenBytes > 0) {
            this.acknowledgedBytes += credit;
        }
        if (((NukleusChannelConfig)this.getConfig()).getThrottle() == NukleusThrottleMode.MESSAGE && this.targetWriteRequestInProgress && this.acknowledgedBytes >= this.acknowlegedBytesCheckpoint) {
            this.completeWriteRequestIfFullyWritten();
        }
    }

    public void capabilities(int capabilities) {
        this.capabilities = capabilities;
    }

    public boolean hasCapability(Capability capability) {
        return (this.capabilities & 1 << capability.ordinal()) != 0;
    }

    public void targetWriteRequestProgressing() {
        if (((NukleusChannelConfig)this.getConfig()).getThrottle() == NukleusThrottleMode.MESSAGE) {
            MessageEvent writeRequest = this.writeRequests.peekFirst();
            ChannelBuffer message = (ChannelBuffer)writeRequest.getMessage();
            this.acknowlegedBytesCheckpoint = this.writtenBytes + message.readableBytes();
            this.targetWriteRequestInProgress = true;
        }
    }

    public ChannelBuffer writeExtBuffer(NukleusExtensionKind writeExtKind, boolean readonly) {
        if (this.writeExtKind != writeExtKind) {
            if (readonly) {
                return ChannelBuffers.EMPTY_BUFFER;
            }
            if (this.writeExtBuffer == null) {
                this.writeExtBuffer = ((NukleusChannelConfig)this.getConfig()).getBufferFactory().getBuffer(8192);
            } else {
                this.writeExtBuffer.clear();
            }
            this.writeExtKind = writeExtKind;
        }
        return this.writeExtBuffer;
    }

    public ChannelBuffer readExtBuffer(NukleusExtensionKind readExtKind) {
        if (this.readExtKind != readExtKind) {
            if (this.readExtBuffer == null) {
                this.readExtBuffer = ((NukleusChannelConfig)this.getConfig()).getBufferFactory().getBuffer(8192);
            } else {
                this.readExtBuffer.clear();
            }
            this.readExtKind = readExtKind;
        }
        return this.readExtBuffer;
    }

    public void targetWriteRequestProgress() {
        switch (((NukleusChannelConfig)this.getConfig()).getThrottle()) {
            case MESSAGE: {
                if (!this.targetWriteRequestInProgress || this.acknowledgedBytes < this.acknowlegedBytesCheckpoint) break;
                this.completeWriteRequestIfFullyWritten();
                break;
            }
            default: {
                this.completeWriteRequestIfFullyWritten();
            }
        }
    }

    public boolean isTargetWriteRequestInProgress() {
        return this.targetWriteRequestInProgress;
    }

    public void setFlushable() {
        this.flushable = true;
    }

    public boolean isFlushable() {
        return this.flushable;
    }

    private void cleanupCreditor(ChannelFuture future) throws Exception {
        assert (this.creditorIndex != -1L);
        this.creditor.release(this.creditorIndex);
        this.creditorIndex = -1L;
    }

    private void cleanupDebitor(ChannelFuture future) throws Exception {
        assert (this.debitorIndex != -1L);
        this.debitor.release(this.debitorIndex, this.targetId);
        this.debitorIndex = -1L;
        this.debitorId = 0L;
    }

    private void completeWriteRequestIfFullyWritten() {
        MessageEvent writeRequest = this.writeRequests.peekFirst();
        ChannelBuffer message = (ChannelBuffer)writeRequest.getMessage();
        if (!message.readable()) {
            this.targetWriteRequestInProgress = false;
            this.writeRequests.removeFirst();
            writeRequest.getFuture().setSuccess();
        }
    }
}

