/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.test.internal.k3po.ext.behavior.config;

import java.util.List;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.channel.Channel;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.ConfigEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageEncoder;
import org.kaazing.k3po.lang.types.StructuredTypeInfo;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusChannel;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusChannelConfig;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusExtensionKind;

public final class NukleusExtensionEncoder
implements ConfigEncoder {
    private final NukleusExtensionKind writeExtKind;
    private final StructuredTypeInfo type;
    private final List<MessageEncoder> encoders;

    public NukleusExtensionEncoder(NukleusExtensionKind writeExtKind, StructuredTypeInfo type, List<MessageEncoder> encoders) {
        this.writeExtKind = writeExtKind;
        this.type = type;
        this.encoders = Objects.requireNonNull(encoders);
    }

    public void encode(Channel channel) throws Exception {
        this.encode((NukleusChannel)channel);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type.getQualifiedName()).append(' ');
        for (MessageEncoder encoder : this.encoders) {
            sb.append(encoder).append(' ');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private void encode(NukleusChannel channel) {
        NukleusChannelConfig config = (NukleusChannelConfig)channel.getConfig();
        ChannelBufferFactory bufferFactory = config.getBufferFactory();
        for (MessageEncoder encoder : this.encoders) {
            channel.writeExtBuffer(this.writeExtKind, false).writeBytes(encoder.encode(bufferFactory));
        }
    }
}

