/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.test.internal.k3po.ext.behavior.config;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.kaazing.k3po.driver.internal.behavior.ScriptProgressException;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.ConfigEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.command.AbstractCommandHandler;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NullChannelBuffer;

public class WriteChallengeHandler
extends AbstractCommandHandler {
    private final List<ConfigEncoder> encoders;

    public WriteChallengeHandler(ConfigEncoder encoder) {
        this(Collections.singletonList(encoder));
    }

    public WriteChallengeHandler(List<ConfigEncoder> encoders) {
        this.encoders = Objects.requireNonNull(encoders, "encoders");
    }

    protected void invokeCommand(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.getChannel();
        for (ConfigEncoder encoder : this.encoders) {
            encoder.encode(channel);
        }
        final ChannelFuture handlerFuture = this.getHandlerFuture();
        ChannelFuture challengeFuture = Channels.future((Channel)ctx.getChannel());
        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)challengeFuture, (Object)((Object)NullChannelBuffer.CHALLENGE_BUFFER));
        challengeFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    handlerFuture.setSuccess();
                } else {
                    handlerFuture.setFailure((Throwable)new ScriptProgressException(WriteChallengeHandler.this.getRegionInfo(), future.getCause().getMessage()));
                }
            }
        });
    }

    protected StringBuilder describe(StringBuilder sb) {
        return sb.append(String.format("write %s", this.encoders));
    }
}

