/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.test.internal.k3po.ext.behavior.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.ConfigDecoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageDecoder;
import org.kaazing.k3po.lang.types.StructuredTypeInfo;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusChannel;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusExtensionKind;

public final class NukleusExtensionDecoder
implements ConfigDecoder {
    private final NukleusExtensionKind readExtKind;
    private final StructuredTypeInfo type;
    private final List<MessageDecoder> decoders;
    private final List<MessageDecoder> remainingDecoders;

    public NukleusExtensionDecoder(NukleusExtensionKind readExtKind, StructuredTypeInfo type, List<MessageDecoder> decoders) {
        this.readExtKind = readExtKind;
        this.type = type;
        this.decoders = Objects.requireNonNull(decoders);
        this.remainingDecoders = new ArrayList<MessageDecoder>(decoders);
    }

    public boolean decode(Channel channel) throws Exception {
        return this.decode((NukleusChannel)channel);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type.getQualifiedName()).append(' ');
        for (MessageDecoder decoder : this.decoders) {
            sb.append(decoder).append(' ');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private boolean decode(NukleusChannel channel) throws Exception {
        ChannelBuffer readExtBuffer = channel.readExtBuffer(this.readExtKind);
        Iterator<MessageDecoder> iterator = this.remainingDecoders.iterator();
        while (iterator.hasNext()) {
            MessageDecoder decoder = iterator.next();
            ChannelBuffer remainingExtBuffer = iterator.hasNext() ? decoder.decode(readExtBuffer) : decoder.decodeLast(readExtBuffer);
            if (remainingExtBuffer == null) {
                return false;
            }
            int remainingExtBytes = remainingExtBuffer.readableBytes();
            if (remainingExtBytes > 0) {
                readExtBuffer.skipBytes(-remainingExtBytes);
            }
            iterator.remove();
        }
        return true;
    }
}

