/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.test;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.reaktivity.nukleus.Configuration;
import org.reaktivity.nukleus.Controller;
import org.reaktivity.nukleus.Nukleus;
import org.reaktivity.nukleus.NukleusFactorySpi;
import org.reaktivity.reaktor.Reaktor;
import org.reaktivity.reaktor.ReaktorBuilder;
import org.reaktivity.reaktor.ReaktorConfiguration;
import org.reaktivity.reaktor.test.Services;
import org.reaktivity.reaktor.test.annotation.Configure;

public final class ReaktorRule
implements TestRule {
    public static final long EXTERNAL_AFFINITY_MASK = Long.MIN_VALUE;
    public static final String REAKTOR_BUFFER_POOL_CAPACITY_NAME = "reaktor.buffer.pool.capacity";
    public static final String REAKTOR_BUFFER_SLOT_CAPACITY_NAME = "reaktor.buffer.slot.capacity";
    private static final Pattern DATA_FILENAME_PATTERN = Pattern.compile("data\\d+");
    private final Properties properties;
    private final ReaktorBuilder builder = Reaktor.builder();
    private Reaktor reaktor;
    private ReaktorConfiguration configuration;
    private boolean clean;

    public ReaktorRule() {
        this.properties = new Properties();
        this.configure((Configuration.PropertyDef)ReaktorConfiguration.REAKTOR_DRAIN_ON_CLOSE, true);
        this.configure((Configuration.PropertyDef)ReaktorConfiguration.REAKTOR_SYNTHETIC_ABORT, true);
        this.configure((Configuration.PropertyDef)ReaktorConfiguration.REAKTOR_ROUTED_DELAY_MILLIS, 500L);
    }

    public ReaktorRule directory(String directory) {
        return this.configure(ReaktorConfiguration.REAKTOR_DIRECTORY, directory);
    }

    public ReaktorRule commandBufferCapacity(int commandBufferCapacity) {
        return this.configure((Configuration.PropertyDef)ReaktorConfiguration.REAKTOR_COMMAND_BUFFER_CAPACITY, commandBufferCapacity);
    }

    public ReaktorRule responseBufferCapacity(int responseBufferCapacity) {
        return this.configure((Configuration.PropertyDef)ReaktorConfiguration.REAKTOR_RESPONSE_BUFFER_CAPACITY, responseBufferCapacity);
    }

    public ReaktorRule counterValuesBufferCapacity(int counterValuesBufferCapacity) {
        return this.configure((Configuration.PropertyDef)ReaktorConfiguration.REAKTOR_COUNTERS_BUFFER_CAPACITY, counterValuesBufferCapacity);
    }

    public ReaktorRule streamsBufferCapacity(int streamsBufferCapacity) {
        return this.configure((Configuration.PropertyDef)ReaktorConfiguration.REAKTOR_STREAMS_BUFFER_CAPACITY, streamsBufferCapacity);
    }

    public <T> ReaktorRule configure(Configuration.PropertyDef<T> property, T value) {
        this.properties.setProperty(property.name(), value.toString());
        return this;
    }

    public ReaktorRule configure(String name, String value) {
        this.properties.setProperty(name, value);
        return this;
    }

    public ReaktorRule clean() {
        this.clean = true;
        return this;
    }

    public ReaktorRule nukleus(Predicate<String> matcher) {
        this.builder.nukleus(matcher);
        return this;
    }

    public ReaktorRule loader(ClassLoader loader) {
        this.builder.loader(loader);
        return this;
    }

    public ReaktorRule controller(Predicate<String> matcher) {
        this.builder.controller(matcher);
        return this;
    }

    public ReaktorRule affinityMask(String address, long affinityMask) {
        this.builder.affinityMask(address, affinityMask);
        return this;
    }

    public ReaktorRule nukleusFactory(Class<? extends NukleusFactorySpi> factory) {
        this.loader(Services.newLoader(NukleusFactorySpi.class, factory));
        return this;
    }

    public <T extends Controller> T controller(Class<T> kind) {
        this.ensureReaktorStarted();
        return (T)Objects.requireNonNull(this.reaktor.controller(kind));
    }

    public <T extends Nukleus> T nukleus(Class<T> kind) {
        this.ensureReaktorStarted();
        return (T)Objects.requireNonNull(this.reaktor.nukleus(kind));
    }

    public long opensRead(String nukleus, long routeId) {
        return this.counter(String.format("%s.%d.opens.read", nukleus, routeId));
    }

    public long opensWritten(String nukleus, long routeId) {
        return this.counter(String.format("%s.%d.opens.written", nukleus, routeId));
    }

    public long closesRead(String nukleus, long routeId) {
        return this.counter(String.format("%s.%d.closes.read", nukleus, routeId));
    }

    public long closesWritten(String nukleus, long routeId) {
        return this.counter(String.format("%s.%d.closes.written", nukleus, routeId));
    }

    public long abortsRead(String nukleus, long routeId) {
        return this.counter(String.format("%s.%d.aborts.read", nukleus, routeId));
    }

    public long abortsWritten(String nukleus, long routeId) {
        return this.counter(String.format("%s.%d.aborts.written", nukleus, routeId));
    }

    public long resetsRead(String nukleus, long routeId) {
        return this.counter(String.format("%s.%d.resets.read", nukleus, routeId));
    }

    public long resetsWritten(String nukleus, long routeId) {
        return this.counter(String.format("%s.%d.resets.written", nukleus, routeId));
    }

    public long bytesRead(String nukleus, long routeId) {
        return this.counter(String.format("%s.%d.bytes.read", nukleus, routeId));
    }

    public long bytesWritten(String nukleus, long routeId) {
        return this.counter(String.format("%s.%d.bytes.written", nukleus, routeId));
    }

    public long framesRead(String nukleus, long routeId) {
        return this.counter(String.format("%s.%d.frames.read", nukleus, routeId));
    }

    public long framesWritten(String nukleus, long routeId) {
        return this.counter(String.format("%s.%d.frames.written", nukleus, routeId));
    }

    public long counter(String name) {
        this.ensureReaktorStarted();
        return this.reaktor.counter(name);
    }

    private ReaktorConfiguration configuration() {
        if (this.configuration == null) {
            this.configuration = new ReaktorConfiguration(this.properties);
        }
        return this.configuration;
    }

    private void ensureReaktorStarted() {
        if (this.reaktor == null) {
            throw new IllegalStateException("Reaktor not started");
        }
    }

    public Statement apply(final Statement base, Description description) {
        String testMethod = description.getMethodName().replaceAll("\\[.*\\]", "");
        try {
            Configure[] configures = (Configure[])description.getTestClass().getDeclaredMethod(testMethod, new Class[0]).getAnnotationsByType(Configure.class);
            Arrays.stream(configures).forEach(p -> this.properties.setProperty(p.name(), p.value()));
        }
        catch (Exception e) {
            LangUtil.rethrowUnchecked((Throwable)e);
        }
        return new Statement(){

            private boolean shouldDeletePath(Path path) {
                String filename = path.getFileName().toString();
                return "control".equals(filename) || "routes".equals(filename) || "streams".equals(filename) || "labels".equals(filename) || DATA_FILENAME_PATTERN.matcher(filename).matches();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                ReaktorConfiguration config = ReaktorRule.this.configuration();
                Path directory = config.directory();
                Path cacheDirectory = config.cacheDirectory();
                if (ReaktorRule.this.clean && Files.exists(directory, new LinkOption[0])) {
                    Files.walk(directory, FileVisitOption.FOLLOW_LINKS).filter(this::shouldDeletePath).map(Path::toFile).forEach(File::delete);
                }
                if (ReaktorRule.this.clean && Files.exists(cacheDirectory, new LinkOption[0])) {
                    Files.walk(cacheDirectory, new FileVisitOption[0]).map(Path::toFile).forEach(File::delete);
                }
                Thread baseThread = Thread.currentThread();
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                ErrorHandler errorHandler = ex -> {
                    errors.add(ex);
                    baseThread.interrupt();
                };
                ReaktorRule.this.reaktor = ReaktorRule.this.builder.config((Configuration)config).errorHandler(errorHandler).build();
                try {
                    ReaktorRule.this.reaktor.start();
                    base.evaluate();
                }
                catch (Throwable t) {
                    errors.add(t);
                }
                finally {
                    try {
                        ReaktorRule.this.reaktor.close();
                    }
                    catch (Throwable t) {
                        errors.add(t);
                    }
                    finally {
                        MultipleFailureException.assertEmpty(errors);
                    }
                }
            }
        };
    }
}

