/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.test.internal.k3po.ext.behavior;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.netty.channel.ChannelHandler;
import org.kaazing.k3po.driver.internal.behavior.BehaviorSystemSpi;
import org.kaazing.k3po.driver.internal.behavior.ReadAdviseFactory;
import org.kaazing.k3po.driver.internal.behavior.ReadAdvisedFactory;
import org.kaazing.k3po.driver.internal.behavior.ReadConfigFactory;
import org.kaazing.k3po.driver.internal.behavior.ReadOptionFactory;
import org.kaazing.k3po.driver.internal.behavior.WriteAdviseFactory;
import org.kaazing.k3po.driver.internal.behavior.WriteAdvisedFactory;
import org.kaazing.k3po.driver.internal.behavior.WriteConfigFactory;
import org.kaazing.k3po.driver.internal.behavior.WriteOptionFactory;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.ChannelDecoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.ChannelEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageDecoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.command.ReadAdviseHandler;
import org.kaazing.k3po.driver.internal.behavior.handler.command.WriteAdviseHandler;
import org.kaazing.k3po.driver.internal.behavior.handler.command.WriteConfigHandler;
import org.kaazing.k3po.driver.internal.behavior.handler.event.ReadAdvisedHandler;
import org.kaazing.k3po.driver.internal.behavior.handler.event.WriteAdvisedHandler;
import org.kaazing.k3po.lang.internal.RegionInfo;
import org.kaazing.k3po.lang.internal.ast.AstReadAdviseNode;
import org.kaazing.k3po.lang.internal.ast.AstReadAdvisedNode;
import org.kaazing.k3po.lang.internal.ast.AstReadConfigNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteAdviseNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteAdvisedNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteConfigNode;
import org.kaazing.k3po.lang.internal.ast.matcher.AstValueMatcher;
import org.kaazing.k3po.lang.internal.ast.value.AstValue;
import org.kaazing.k3po.lang.types.StructuredTypeInfo;
import org.kaazing.k3po.lang.types.TypeInfo;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusExtensionKind;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.handler.NukleusExtensionDecoder;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.handler.NukleusExtensionEncoder;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.handler.ReadBeginExtHandler;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.handler.ReadDataExtHandler;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.handler.ReadEndExtHandler;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.handler.ReadNullDataHandler;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.handler.WriteEmptyDataHandler;
import org.reaktivity.reaktor.test.internal.k3po.ext.types.NukleusTypeSystem;

public class NukleusBehaviorSystem
implements BehaviorSystemSpi {
    private final Map<TypeInfo<?>, ReadOptionFactory> readOptionFactories = Collections.emptyMap();
    private final Map<TypeInfo<?>, WriteOptionFactory> writeOptionFactories = Collections.emptyMap();
    private final Map<StructuredTypeInfo, ReadConfigFactory> readConfigFactories;
    private final Map<StructuredTypeInfo, WriteConfigFactory> writeConfigFactories;
    private final Map<StructuredTypeInfo, ReadAdviseFactory> readAdviseFactories;
    private final Map<StructuredTypeInfo, WriteAdviseFactory> writeAdviseFactories;
    private final Map<StructuredTypeInfo, ReadAdvisedFactory> readAdvisedFactories;
    private final Map<StructuredTypeInfo, WriteAdvisedFactory> writeAdvisedFactories;

    public NukleusBehaviorSystem() {
        LinkedHashMap<StructuredTypeInfo, ReadConfigFactory> readConfigFactories = new LinkedHashMap<StructuredTypeInfo, ReadConfigFactory>();
        readConfigFactories.put(NukleusTypeSystem.CONFIG_BEGIN_EXT, NukleusBehaviorSystem::newReadBeginExtHandler);
        readConfigFactories.put(NukleusTypeSystem.CONFIG_DATA_EXT, NukleusBehaviorSystem::newReadDataExtHandler);
        readConfigFactories.put(NukleusTypeSystem.CONFIG_DATA_NULL, NukleusBehaviorSystem::newReadNullDataHandler);
        readConfigFactories.put(NukleusTypeSystem.CONFIG_END_EXT, NukleusBehaviorSystem::newReadEndExtHandler);
        this.readConfigFactories = Collections.unmodifiableMap(readConfigFactories);
        LinkedHashMap<StructuredTypeInfo, WriteConfigFactory> writeConfigFactories = new LinkedHashMap<StructuredTypeInfo, WriteConfigFactory>();
        writeConfigFactories.put(NukleusTypeSystem.CONFIG_BEGIN_EXT, NukleusBehaviorSystem::newWriteBeginExtHandler);
        writeConfigFactories.put(NukleusTypeSystem.CONFIG_DATA_EMPTY, NukleusBehaviorSystem::newWriteEmptyDataHandler);
        writeConfigFactories.put(NukleusTypeSystem.CONFIG_DATA_EXT, NukleusBehaviorSystem::newWriteDataExtHandler);
        writeConfigFactories.put(NukleusTypeSystem.CONFIG_END_EXT, NukleusBehaviorSystem::newWriteEndExtHandler);
        this.writeConfigFactories = Collections.unmodifiableMap(writeConfigFactories);
        LinkedHashMap<StructuredTypeInfo, ReadAdviseFactory> readAdviseFactories = new LinkedHashMap<StructuredTypeInfo, ReadAdviseFactory>();
        readAdviseFactories.put(NukleusTypeSystem.ADVISORY_CHALLENGE, NukleusBehaviorSystem::newReadAdviseChallengeHandler);
        this.readAdviseFactories = Collections.unmodifiableMap(readAdviseFactories);
        LinkedHashMap<StructuredTypeInfo, WriteAdvisedFactory> writeAdvisedFactories = new LinkedHashMap<StructuredTypeInfo, WriteAdvisedFactory>();
        writeAdvisedFactories.put(NukleusTypeSystem.ADVISORY_CHALLENGE, NukleusBehaviorSystem::newWriteAdvisedChallengeHandler);
        this.writeAdvisedFactories = Collections.unmodifiableMap(writeAdvisedFactories);
        LinkedHashMap<StructuredTypeInfo, WriteAdviseFactory> writeAdviseFactories = new LinkedHashMap<StructuredTypeInfo, WriteAdviseFactory>();
        writeAdviseFactories.put(NukleusTypeSystem.ADVISORY_FLUSH, NukleusBehaviorSystem::newWriteAdviseFlushHandler);
        this.writeAdviseFactories = Collections.unmodifiableMap(writeAdviseFactories);
        LinkedHashMap<StructuredTypeInfo, ReadAdvisedFactory> readAdvisedFactories = new LinkedHashMap<StructuredTypeInfo, ReadAdvisedFactory>();
        readAdvisedFactories.put(NukleusTypeSystem.ADVISORY_FLUSH, NukleusBehaviorSystem::newReadAdvisedFlushHandler);
        this.readAdvisedFactories = Collections.unmodifiableMap(readAdvisedFactories);
        Set readAdviseKeys = readAdviseFactories.keySet();
        Set writeAdviseKeys = writeAdviseFactories.keySet();
        assert (Objects.equals(readAdviseKeys, writeAdvisedFactories.keySet()));
        assert (Objects.equals(writeAdviseKeys, readAdvisedFactories.keySet()));
    }

    public Set<StructuredTypeInfo> getReadConfigTypes() {
        return this.readConfigFactories.keySet();
    }

    public Set<StructuredTypeInfo> getWriteConfigTypes() {
        return this.writeConfigFactories.keySet();
    }

    public ReadConfigFactory readConfigFactory(StructuredTypeInfo configType) {
        return this.readConfigFactories.get(configType);
    }

    public WriteConfigFactory writeConfigFactory(StructuredTypeInfo configType) {
        return this.writeConfigFactories.get(configType);
    }

    public Set<TypeInfo<?>> getReadOptionTypes() {
        return this.readOptionFactories.keySet();
    }

    public Set<TypeInfo<?>> getWriteOptionTypes() {
        return this.writeOptionFactories.keySet();
    }

    public ReadOptionFactory readOptionFactory(TypeInfo<?> optionType) {
        return this.readOptionFactories.get(optionType);
    }

    public WriteOptionFactory writeOptionFactory(TypeInfo<?> optionType) {
        return this.writeOptionFactories.get(optionType);
    }

    public Set<StructuredTypeInfo> getReadAdvisoryTypes() {
        return this.readAdviseFactories.keySet();
    }

    public Set<StructuredTypeInfo> getWriteAdvisoryTypes() {
        return this.writeAdviseFactories.keySet();
    }

    public ReadAdviseFactory readAdviseFactory(StructuredTypeInfo advisoryType) {
        return this.readAdviseFactories.get(advisoryType);
    }

    public ReadAdvisedFactory readAdvisedFactory(StructuredTypeInfo advisoryType) {
        return this.readAdvisedFactories.get(advisoryType);
    }

    public WriteAdviseFactory writeAdviseFactory(StructuredTypeInfo advisoryType) {
        return this.writeAdviseFactories.get(advisoryType);
    }

    public WriteAdvisedFactory writeAdvisedFactory(StructuredTypeInfo advisoryType) {
        return this.writeAdvisedFactories.get(advisoryType);
    }

    private static ReadBeginExtHandler newReadBeginExtHandler(AstReadConfigNode node, Function<AstValueMatcher, MessageDecoder> decoderFactory) {
        RegionInfo regionInfo = node.getRegionInfo();
        StructuredTypeInfo type = node.getType();
        List<MessageDecoder> decoders = node.getMatchers().stream().map(decoderFactory).collect(Collectors.toList());
        NukleusExtensionDecoder decoder = new NukleusExtensionDecoder(NukleusExtensionKind.BEGIN, type, decoders);
        ReadBeginExtHandler handler = new ReadBeginExtHandler(decoder);
        handler.setRegionInfo(regionInfo);
        return handler;
    }

    private static ReadDataExtHandler newReadDataExtHandler(AstReadConfigNode node, Function<AstValueMatcher, MessageDecoder> decoderFactory) {
        RegionInfo regionInfo = node.getRegionInfo();
        StructuredTypeInfo type = node.getType();
        List<MessageDecoder> decoders = node.getMatchers().stream().map(decoderFactory).collect(Collectors.toList());
        NukleusExtensionDecoder decoder = new NukleusExtensionDecoder(NukleusExtensionKind.DATA, type, decoders);
        ReadDataExtHandler handler = new ReadDataExtHandler(decoder);
        handler.setRegionInfo(regionInfo);
        return handler;
    }

    private static ChannelHandler newReadNullDataHandler(AstReadConfigNode node, Function<AstValueMatcher, MessageDecoder> decoderFactory) {
        RegionInfo regionInfo = node.getRegionInfo();
        ReadNullDataHandler handler = new ReadNullDataHandler();
        handler.setRegionInfo(regionInfo);
        return handler;
    }

    private static ReadEndExtHandler newReadEndExtHandler(AstReadConfigNode node, Function<AstValueMatcher, MessageDecoder> decoderFactory) {
        RegionInfo regionInfo = node.getRegionInfo();
        StructuredTypeInfo type = node.getType();
        List<MessageDecoder> decoders = node.getMatchers().stream().map(decoderFactory).collect(Collectors.toList());
        NukleusExtensionDecoder decoder = new NukleusExtensionDecoder(NukleusExtensionKind.END, type, decoders);
        ReadEndExtHandler handler = new ReadEndExtHandler(decoder);
        handler.setRegionInfo(regionInfo);
        return handler;
    }

    private static WriteConfigHandler newWriteBeginExtHandler(AstWriteConfigNode node, Function<AstValue<?>, MessageEncoder> encoderFactory) {
        StructuredTypeInfo type = node.getType();
        List<MessageEncoder> encoders = node.getValues().stream().map(encoderFactory).collect(Collectors.toList());
        NukleusExtensionEncoder encoder = new NukleusExtensionEncoder(NukleusExtensionKind.BEGIN, type, encoders);
        WriteConfigHandler handler = new WriteConfigHandler((ChannelEncoder)encoder);
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static WriteConfigHandler newWriteDataExtHandler(AstWriteConfigNode node, Function<AstValue<?>, MessageEncoder> encoderFactory) {
        StructuredTypeInfo type = node.getType();
        List<MessageEncoder> encoders = node.getValues().stream().map(encoderFactory).collect(Collectors.toList());
        NukleusExtensionEncoder encoder = new NukleusExtensionEncoder(NukleusExtensionKind.DATA, type, encoders);
        WriteConfigHandler handler = new WriteConfigHandler((ChannelEncoder)encoder);
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static WriteEmptyDataHandler newWriteEmptyDataHandler(AstWriteConfigNode node, Function<AstValue<?>, MessageEncoder> encoderFactory) {
        WriteEmptyDataHandler handler = new WriteEmptyDataHandler();
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static WriteConfigHandler newWriteEndExtHandler(AstWriteConfigNode node, Function<AstValue<?>, MessageEncoder> encoderFactory) {
        StructuredTypeInfo type = node.getType();
        List<MessageEncoder> encoders = node.getValues().stream().map(encoderFactory).collect(Collectors.toList());
        NukleusExtensionEncoder encoder = new NukleusExtensionEncoder(NukleusExtensionKind.END, type, encoders);
        WriteConfigHandler handler = new WriteConfigHandler((ChannelEncoder)encoder);
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static WriteAdviseHandler newWriteAdviseFlushHandler(AstWriteAdviseNode node, Function<AstValue<?>, MessageEncoder> encoderFactory) {
        StructuredTypeInfo type = node.getType();
        List<MessageEncoder> encoders = node.getValues().stream().map(encoderFactory).collect(Collectors.toList());
        NukleusExtensionEncoder encoder = new NukleusExtensionEncoder(NukleusExtensionKind.FLUSH, type, encoders);
        WriteAdviseHandler handler = new WriteAdviseHandler((Object)NukleusTypeSystem.ADVISORY_FLUSH, (ChannelEncoder)encoder);
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static ReadAdvisedHandler newReadAdvisedFlushHandler(AstReadAdvisedNode node, Function<AstValueMatcher, MessageDecoder> decoderFactory) {
        RegionInfo regionInfo = node.getRegionInfo();
        StructuredTypeInfo type = node.getType();
        List<MessageDecoder> decoders = node.getMatchers().stream().map(decoderFactory).collect(Collectors.toList());
        NukleusExtensionDecoder decoder = new NukleusExtensionDecoder(NukleusExtensionKind.FLUSH, type, decoders);
        ReadAdvisedHandler handler = new ReadAdvisedHandler((Object)NukleusTypeSystem.ADVISORY_FLUSH, (ChannelDecoder)decoder);
        handler.setRegionInfo(regionInfo);
        return handler;
    }

    private static ReadAdviseHandler newReadAdviseChallengeHandler(AstReadAdviseNode node, Function<AstValue<?>, MessageEncoder> encoderFactory) {
        StructuredTypeInfo type = node.getType();
        List<MessageEncoder> encoders = node.getValues().stream().map(encoderFactory).collect(Collectors.toList());
        NukleusExtensionEncoder encoder = new NukleusExtensionEncoder(NukleusExtensionKind.CHALLENGE, type, encoders);
        ReadAdviseHandler handler = new ReadAdviseHandler((Object)NukleusTypeSystem.ADVISORY_CHALLENGE, (ChannelEncoder)encoder);
        handler.setRegionInfo(node.getRegionInfo());
        return handler;
    }

    private static WriteAdvisedHandler newWriteAdvisedChallengeHandler(AstWriteAdvisedNode node, Function<AstValueMatcher, MessageDecoder> decoderFactory) {
        RegionInfo regionInfo = node.getRegionInfo();
        StructuredTypeInfo type = node.getType();
        List<MessageDecoder> decoders = node.getMatchers().stream().map(decoderFactory).collect(Collectors.toList());
        NukleusExtensionDecoder decoder = new NukleusExtensionDecoder(NukleusExtensionKind.CHALLENGE, type, decoders);
        WriteAdvisedHandler handler = new WriteAdvisedHandler((Object)NukleusTypeSystem.ADVISORY_CHALLENGE, (ChannelDecoder)decoder);
        handler.setRegionInfo(regionInfo);
        return handler;
    }
}

