/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.test.internal.k3po.ext.behavior;

import java.util.Properties;
import org.jboss.netty.channel.ChannelFactory;
import org.kaazing.k3po.driver.internal.netty.bootstrap.BootstrapFactorySpi;
import org.kaazing.k3po.driver.internal.netty.bootstrap.ClientBootstrap;
import org.kaazing.k3po.driver.internal.netty.bootstrap.ServerBootstrap;
import org.reaktivity.reaktor.test.internal.k3po.ext.NukleusExtConfiguration;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusClientChannelFactory;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusReaktorPool;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusServerChannelFactory;

public class NukleusBootstrapFactory
extends BootstrapFactorySpi {
    private final ChannelFactory clientChannelFactory;
    private final ChannelFactory serverChannelFactory;
    private final NukleusReaktorPool reaktorPool;

    public NukleusBootstrapFactory() {
        Properties properties = new Properties();
        properties.setProperty(NukleusExtConfiguration.NUKLEUS_EXT_DIRECTORY.name(), "target/nukleus-itests");
        NukleusExtConfiguration config = new NukleusExtConfiguration(properties);
        this.reaktorPool = new NukleusReaktorPool(config);
        this.clientChannelFactory = new NukleusClientChannelFactory(this.reaktorPool);
        this.serverChannelFactory = new NukleusServerChannelFactory(this.reaktorPool);
    }

    public String getTransportName() {
        return "nukleus";
    }

    public ClientBootstrap newClientBootstrap() throws Exception {
        return new ClientBootstrap(this.clientChannelFactory);
    }

    public ServerBootstrap newServerBootstrap() throws Exception {
        return new ServerBootstrap(this.serverChannelFactory);
    }

    public void shutdown() {
        this.reaktorPool.shutdown();
        this.clientChannelFactory.shutdown();
        this.serverChannelFactory.shutdown();
    }

    public void releaseExternalResources() {
        this.shutdown();
        this.reaktorPool.releaseExternalResources();
        this.clientChannelFactory.releaseExternalResources();
        this.serverChannelFactory.releaseExternalResources();
    }
}

