/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.agrona.LangUtil;

public final class LabelManager {
    private final List<String> labels = new ArrayList<String>();
    private final Map<String, Integer> labelIds = new HashMap<String, Integer>();
    private final Path labelsPath;
    private long sizeInBytes;

    public LabelManager(Path directory) {
        this.labelsPath = directory.resolve("labels");
        this.sizeInBytes = -1L;
    }

    public synchronized int supplyLabelId(String label) {
        this.checkSnapshot();
        return this.labelIds.computeIfAbsent(label, this::nextLabelId);
    }

    public synchronized String lookupLabel(int labelId) {
        if (labelId < 1 || labelId > this.labels.size()) {
            this.checkSnapshot();
        }
        return this.labels.get(labelId - 1);
    }

    private int nextLabelId(String nextLabel) {
        try (FileChannel channel = FileChannel.open(this.labelsPath, StandardOpenOption.APPEND);
             BufferedWriter out = new BufferedWriter(Channels.newWriter((WritableByteChannel)channel, StandardCharsets.UTF_8.name()));){
            out.write(nextLabel);
            out.write(10);
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        this.labels.add(nextLabel);
        return this.labels.size();
    }

    private void checkSnapshot() {
        block15: {
            try {
                if (!Files.exists(this.labelsPath, new LinkOption[0])) {
                    this.sizeInBytes = -1L;
                }
                if (this.sizeInBytes != -1L && this.sizeInBytes >= Files.size(this.labelsPath)) break block15;
                Files.createDirectories(this.labelsPath.getParent(), new FileAttribute[0]);
                try (FileChannel channel = FileChannel.open(this.labelsPath, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);){
                    this.labels.clear();
                    this.labelIds.clear();
                    try (BufferedReader in = new BufferedReader(Channels.newReader((ReadableByteChannel)channel, StandardCharsets.UTF_8.name()));){
                        String label = in.readLine();
                        while (label != null) {
                            this.labels.add(label);
                            this.labelIds.put(label, this.labels.size());
                            label = in.readLine();
                        }
                        this.sizeInBytes = channel.position();
                    }
                }
            }
            catch (IOException ex) {
                LangUtil.rethrowUnchecked((Throwable)ex);
            }
        }
    }
}

