/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.layouts;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.file.Path;
import org.agrona.CloseHelper;
import org.agrona.IoUtil;
import org.reaktivity.nukleus.buffer.BufferPool;
import org.reaktivity.reaktor.internal.buffer.DefaultBufferPool;
import org.reaktivity.reaktor.internal.layouts.Layout;

public final class BufferPoolLayout
extends Layout {
    private final DefaultBufferPool bufferPool;

    private BufferPoolLayout(DefaultBufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    public BufferPool bufferPool() {
        return this.bufferPool;
    }

    @Override
    public void close() {
        IoUtil.unmap((ByteBuffer)this.bufferPool.poolBuffer().byteBuffer());
    }

    public static final class Builder
    extends Layout.Builder<BufferPoolLayout> {
        private int slotCount;
        private int slotCapacity;
        private Path path;
        private boolean readonly;

        public Builder slotCount(int slotCount) {
            this.slotCount = slotCount;
            return this;
        }

        public Builder slotCapacity(int slotCapacity) {
            this.slotCapacity = slotCapacity;
            return this;
        }

        public Builder path(Path path) {
            this.path = path;
            return this;
        }

        public Builder readonly(boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        @Override
        public BufferPoolLayout build() {
            File layoutFile = this.path.toFile();
            if (!this.readonly) {
                int slotCountIndex = (this.slotCapacity + 8) * this.slotCount;
                int totalLength = slotCountIndex + 4;
                CloseHelper.close((AutoCloseable)IoUtil.createEmptyFile((File)layoutFile, (long)totalLength));
                MappedByteBuffer metadata = IoUtil.mapExistingFile((File)layoutFile, (String)"slotCount", (long)(totalLength - 4), (long)4L);
                metadata.putInt(0, this.slotCount);
                IoUtil.unmap((MappedByteBuffer)metadata);
            }
            MappedByteBuffer mapped = IoUtil.mapExistingFile((File)layoutFile, (String)"bufferPool");
            return new BufferPoolLayout(new DefaultBufferPool(this.slotCapacity, this.slotCount, mapped));
        }
    }
}

