/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.Agent;
import org.reaktivity.nukleus.AgentBuilder;
import org.reaktivity.nukleus.Configuration;
import org.reaktivity.nukleus.Controller;
import org.reaktivity.nukleus.ControllerFactory;
import org.reaktivity.nukleus.Nukleus;
import org.reaktivity.nukleus.NukleusFactory;
import org.reaktivity.reaktor.Reaktor;
import org.reaktivity.reaktor.ReaktorConfiguration;
import org.reaktivity.reaktor.internal.ControllerBuilderImpl;
import org.reaktivity.reaktor.internal.agent.ControllerAgent;
import org.reaktivity.reaktor.internal.agent.ElektronAgent;
import org.reaktivity.reaktor.internal.agent.NukleusAgent;

public class ReaktorBuilder {
    private Configuration config;
    private Predicate<String> nukleusMatcher = n -> false;
    private Predicate<String> controllerMatcher = c -> false;
    private Map<String, BitSet> affinityMasks = new ConcurrentHashMap<String, BitSet>();
    private Function<String, BitSet> affinityMaskDefault;
    private ErrorHandler errorHandler;
    private Supplier<NukleusFactory> supplyNukleusFactory;
    private Supplier<AgentBuilder> supplyAgentBuilder;
    private ThreadFactory threadFactory;
    private int threads = 1;
    private BitSet affinityMaskDefaultBits = BitSet.valueOf(new long[]{(1L << this.threads) - 1L});

    ReaktorBuilder() {
        this.affinityMaskDefault = n -> this.affinityMaskDefaultBits;
        this.supplyNukleusFactory = NukleusFactory::instantiate;
        this.threadFactory = Thread::new;
    }

    public ReaktorBuilder config(Configuration config) {
        this.config = Objects.requireNonNull(config);
        return this;
    }

    public ReaktorBuilder threads(int threads) {
        this.threads = threads;
        this.affinityMaskDefaultBits = BitSet.valueOf(new long[]{(1L << threads) - 1L});
        return this;
    }

    public ReaktorBuilder nukleus(Predicate<String> matcher) {
        Objects.requireNonNull(matcher);
        this.nukleusMatcher = n -> matcher.test((String)n);
        return this;
    }

    public ReaktorBuilder controller(Predicate<String> matcher) {
        Objects.requireNonNull(matcher);
        this.controllerMatcher = c -> matcher.test((String)c);
        return this;
    }

    public ReaktorBuilder affinityMaskDefault(Function<String, BitSet> affinityMaskDefault) {
        this.affinityMaskDefault = affinityMaskDefault;
        return this;
    }

    public ReaktorBuilder affinityMask(String address, long affinityMask) {
        BitSet affinityBits = BitSet.valueOf(new long[]{affinityMask});
        this.affinityMasks.put(address, affinityBits);
        return this;
    }

    public ReaktorBuilder errorHandler(ErrorHandler errorHandler) {
        this.errorHandler = Objects.requireNonNull(errorHandler);
        return this;
    }

    public ReaktorBuilder loader(ClassLoader loader) {
        Objects.requireNonNull(loader);
        this.supplyNukleusFactory = () -> NukleusFactory.instantiate((ClassLoader)loader);
        return this;
    }

    public ReaktorBuilder supplyAgentBuilder(Supplier<AgentBuilder> supplyAgentBuilder) {
        this.supplyAgentBuilder = supplyAgentBuilder;
        return this;
    }

    public Reaktor build() {
        LinkedHashSet<Configuration> configs = new LinkedHashSet<Configuration>();
        ReaktorConfiguration config = new ReaktorConfiguration(this.config != null ? this.config : new Configuration());
        configs.add(config);
        ArrayList<Nukleus> nuklei = new ArrayList<Nukleus>();
        NukleusFactory nukleusFactory = this.supplyNukleusFactory.get();
        for (String name : nukleusFactory.names()) {
            if (!this.nukleusMatcher.test(name)) continue;
            Nukleus nukleus = nukleusFactory.create(name, (Configuration)config);
            configs.add(nukleus.config());
            nuklei.add(nukleus);
        }
        NukleusAgent nukleusAgent = null;
        if (!nuklei.isEmpty() || this.supplyAgentBuilder != null) {
            nukleusAgent = new NukleusAgent(config, this.supplyAgentBuilder);
            nuklei.forEach(nukleusAgent::assign);
        }
        ArrayList<Controller> controllers = new ArrayList<Controller>();
        ControllerFactory controllerFactory = ControllerFactory.instantiate();
        for (Class kind : controllerFactory.kinds()) {
            String name = controllerFactory.name(kind);
            if (!this.controllerMatcher.test(name)) continue;
            ControllerBuilderImpl builder = new ControllerBuilderImpl(config, kind);
            Controller controller = controllerFactory.create((Configuration)config, builder);
            controllers.add(controller);
        }
        int parallelism = config.taskParallelism();
        ExecutorService executor = Executors.newFixedThreadPool(parallelism, new ReaktorTaskThreadFactory());
        int count = this.threads;
        ElektronAgent[] elektronAgents = new ElektronAgent[count];
        if (nukleusAgent != null) {
            BiFunction<String, BitSet, BitSet> remapper = (k, v) -> v != null ? v : this.affinityMaskDefault.apply((String)k);
            Function<String, BitSet> affinityMask = n -> this.affinityMasks.compute((String)n, remapper);
            for (int index = 0; index < count; ++index) {
                elektronAgents[index] = nukleusAgent.supplyElektronAgent(index, count, executor, affinityMask);
            }
        }
        ControllerAgent controllerAgent = new ControllerAgent();
        controllers.forEach(controllerAgent::assign);
        ErrorHandler errorHandler = Objects.requireNonNull(this.errorHandler, "errorHandler");
        ArrayList<Object> agents = new ArrayList<Object>();
        if (nukleusAgent != null) {
            for (ElektronAgent elektronAgent : elektronAgents) {
                agents.add(elektronAgent);
            }
            agents.add(nukleusAgent);
        }
        if (!controllerAgent.isEmpty()) {
            agents.add(controllerAgent);
        }
        return new Reaktor(config, errorHandler, configs, executor, agents.toArray(new Agent[0]), this.threadFactory);
    }

    private static final class ReaktorTaskThreadFactory
    implements ThreadFactory {
        private final AtomicInteger nextThreadId = new AtomicInteger();
        private final ThreadFactory factory = Executors.defaultThreadFactory();

        private ReaktorTaskThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.factory.newThread(r);
            if (t != null) {
                t.setName(String.format("reaktor/task#%d", this.nextThreadId.getAndIncrement()));
            }
            return t;
        }
    }
}

