/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.layouts;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.reaktor.internal.layouts.Layout;

public final class RoutesLayout
extends Layout {
    private final AtomicBuffer routesBuffer;

    private RoutesLayout(AtomicBuffer routesBuffer) {
        this.routesBuffer = routesBuffer;
    }

    @Override
    public void close() {
        IoUtil.unmap((ByteBuffer)this.routesBuffer().byteBuffer());
    }

    public AtomicBuffer routesBuffer() {
        return this.routesBuffer;
    }

    public static final class Builder
    extends Layout.Builder<RoutesLayout> {
        private Path path;
        private int capacity;
        private boolean readonly;

        public Builder routesPath(Path path) {
            this.path = path;
            return this;
        }

        public Builder routesBufferCapacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        public Builder readonly(boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        @Override
        public RoutesLayout build() {
            File routes = this.path.toFile();
            if (!this.readonly) {
                try (FileChannel channel = IoUtil.createEmptyFile((File)routes, (long)this.capacity);){
                    ByteBuffer empty = ByteBuffer.allocate(12).order(ByteOrder.nativeOrder());
                    empty.putInt(0);
                    empty.putInt(4);
                    empty.putInt(0);
                    empty.flip();
                    channel.position(0L);
                    channel.write(empty);
                }
                catch (IOException ex) {
                    LangUtil.rethrowUnchecked((Throwable)ex);
                }
            }
            MappedByteBuffer mappedRoutes = IoUtil.mapExistingFile((File)routes, (String)"routes");
            UnsafeBuffer routesBuffer = new UnsafeBuffer((ByteBuffer)mappedRoutes);
            return new RoutesLayout((AtomicBuffer)routesBuffer);
        }
    }
}

