/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.router;

public final class StreamId {
    public static int streamIndex(long streamId) {
        return StreamId.isInitial(streamId) ? StreamId.localIndex(streamId) : StreamId.remoteIndex(streamId);
    }

    public static int throttleIndex(long streamId) {
        return StreamId.isInitial(streamId) ? StreamId.remoteIndex(streamId) : StreamId.localIndex(streamId);
    }

    public static int localIndex(long streamId) {
        return (int)(streamId >> 56) & 0x7F;
    }

    public static int remoteIndex(long streamId) {
        return (int)(streamId >> 48) & 0x7F;
    }

    public static int instanceId(long streamId) {
        return (int)(streamId & 0xFFFFFFFFL);
    }

    public static long streamId(int localIndex, int remoteIndex, int instanceId) {
        return StreamId.isInitial(instanceId) ? ((long)localIndex & 0x7FL) << 56 | ((long)remoteIndex & 0x7FL) << 48 | (long)instanceId : ((long)remoteIndex & 0x7FL) << 56 | ((long)localIndex & 0x7FL) << 48 | (long)instanceId;
    }

    public static long throttleId(int localIndex, int remoteIndex, int instanceId) {
        return StreamId.isInitial(instanceId) ? ((long)remoteIndex & 0x7FL) << 56 | ((long)localIndex & 0x7FL) << 48 | (long)instanceId : ((long)localIndex & 0x7FL) << 56 | ((long)remoteIndex & 0x7FL) << 48 | (long)instanceId;
    }

    public static boolean isInitial(long streamId) {
        return (streamId & 1L) != 0L;
    }

    private static boolean isInitial(int instanceId) {
        return (instanceId & 1) != 0;
    }

    private StreamId() {
    }
}

