/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.types;

import java.nio.ByteOrder;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.reaktor.internal.types.ArrayFW;
import org.reaktivity.reaktor.internal.types.Flyweight;

public final class Array16FW<V extends Flyweight>
extends ArrayFW<V> {
    private static final int LENGTH_SIZE = 2;
    private static final int FIELD_COUNT_SIZE = 2;
    private static final int LENGTH_OFFSET = 0;
    private static final int FIELD_COUNT_OFFSET = 2;
    private static final int FIELDS_OFFSET = 4;
    private static final int LENGTH_MAX_VALUE = 65535;
    private static final DirectBuffer EMPTY_BUFFER = new UnsafeBuffer();
    private final ByteOrder byteOrder;
    private final V itemRO;
    private final DirectBuffer itemsRO = new UnsafeBuffer(0L, 0);
    private int maxLength;

    public Array16FW(V itemRO) {
        this.itemRO = itemRO;
        this.byteOrder = ByteOrder.nativeOrder();
    }

    public Array16FW(V itemRO, ByteOrder byteOrder) {
        this.itemRO = itemRO;
        this.byteOrder = byteOrder;
    }

    @Override
    public int length() {
        return this.buffer().getShort(this.offset() + 0, this.byteOrder);
    }

    @Override
    public int fieldsOffset() {
        return this.offset() + 4;
    }

    @Override
    public int fieldCount() {
        return this.buffer().getShort(this.offset() + 2, this.byteOrder);
    }

    @Override
    public int maxLength() {
        return this.maxLength;
    }

    @Override
    public void forEach(Consumer<? super V> consumer) {
        int offset = this.offset() + 4;
        for (int i = 0; i < this.fieldCount(); ++i) {
            ((Flyweight)this.itemRO).wrap(this.buffer(), offset, this.limit(), this);
            consumer.accept(this.itemRO);
            offset = ((Flyweight)this.itemRO).limit();
        }
    }

    @Override
    public boolean anyMatch(Predicate<? super V> predicate) {
        int offset = this.offset() + 4;
        for (int i = 0; i < this.fieldCount(); ++i) {
            ((Flyweight)this.itemRO).wrap(this.buffer(), offset, this.maxLimit(), this);
            if (predicate.test(this.itemRO)) {
                return true;
            }
            offset = ((Flyweight)this.itemRO).limit();
        }
        return false;
    }

    @Override
    public V matchFirst(Predicate<? super V> predicate) {
        int offset = this.offset() + 4;
        for (int i = 0; i < this.fieldCount(); ++i) {
            ((Flyweight)this.itemRO).wrap(this.buffer(), offset, this.maxLimit(), this);
            if (predicate.test(this.itemRO)) {
                return this.itemRO;
            }
            offset = ((Flyweight)this.itemRO).limit();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.fieldCount() == 0;
    }

    @Override
    public DirectBuffer items() {
        return this.itemsRO;
    }

    @Override
    public Array16FW<V> wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        int itemsSize = this.limit() - this.fieldsOffset();
        if (itemsSize == 0) {
            this.itemsRO.wrap(EMPTY_BUFFER, 0, 0);
        } else {
            this.itemsRO.wrap(buffer, offset + 4, itemsSize);
        }
        Array16FW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public Array16FW<V> tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        int itemsSize = this.limit() - this.fieldsOffset();
        if (itemsSize == 0) {
            this.itemsRO.wrap(EMPTY_BUFFER, 0, 0);
        } else {
            this.itemsRO.wrap(buffer, offset + 4, itemsSize);
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 2 + this.length();
    }

    public String toString() {
        return String.format("array16<%d, %d>", this.length(), this.fieldCount());
    }

    @Override
    public void maxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public static final class Builder<B extends Flyweight.Builder<V>, V extends Flyweight>
    extends ArrayFW.Builder<Array16FW<V>, B, V> {
        private final ByteOrder byteOrder;
        private final B itemRW;
        private final V itemRO;
        private int fieldCount;
        private int maxLength;

        public Builder(B itemRW, V itemRO) {
            super(new Array16FW<V>(itemRO));
            this.byteOrder = ByteOrder.nativeOrder();
            this.itemRW = itemRW;
            this.itemRO = itemRO;
        }

        public Builder(B itemRW, V itemRO, ByteOrder byteOrder) {
            super(new Array16FW<V>(itemRO));
            this.byteOrder = byteOrder;
            this.itemRW = itemRW;
            this.itemRO = itemRO;
        }

        @Override
        public int fieldsOffset() {
            return this.offset() + 4;
        }

        public Builder<B, V> item(Consumer<B> consumer) {
            ((Flyweight.Builder)this.itemRW).wrap(this);
            consumer.accept(this.itemRW);
            ((Flyweight.Builder)this.itemRW).build();
            this.maxLength = Math.max(this.maxLength, ((Flyweight.Builder)this.itemRW).sizeof());
            Flyweight.checkLimit(((Flyweight.Builder)this.itemRW).limit(), this.maxLimit());
            this.limit(((Flyweight.Builder)this.itemRW).limit());
            ++this.fieldCount;
            return this;
        }

        public Builder<B, V> items(DirectBuffer buffer, int srcOffset, int length, int fieldCount, int maxLength) {
            this.buffer().putBytes(this.offset() + 4, buffer, srcOffset, length);
            int newLimit = this.offset() + 4 + length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.limit(newLimit);
            this.fieldCount = fieldCount;
            this.maxLength = maxLength;
            assert (length <= 65535) : "Length is too large";
            assert (fieldCount <= 65535) : "Field count is too large";
            this.buffer().putShort(this.offset() + 0, (short)length, this.byteOrder);
            this.buffer().putShort(this.offset() + 2, (short)(fieldCount + 2), this.byteOrder);
            return this;
        }

        public Builder<B, V> wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            int newLimit = offset + 4;
            Flyweight.checkLimit(newLimit, maxLimit);
            this.limit(newLimit);
            this.fieldCount = 0;
            this.maxLength = 0;
            return this;
        }

        @Override
        public Array16FW<V> build() {
            int length = this.limit() - this.offset() - 2;
            assert (length <= 65535) : "Length is too large";
            assert (this.fieldCount <= 65535) : "Field count is too large";
            this.buffer().putShort(this.offset() + 0, (short)length, this.byteOrder);
            this.buffer().putShort(this.offset() + 2, (short)this.fieldCount, this.byteOrder);
            ArrayFW array = (ArrayFW)super.build();
            int maxLimit = this.maxLimit();
            this.limit(this.fieldsOffset());
            int itemOffset = this.fieldsOffset();
            ((Flyweight.Builder)this.itemRW).reset(this);
            for (int i = 0; i < this.fieldCount; ++i) {
                Flyweight item = ((Flyweight)this.itemRO).wrap((DirectBuffer)this.buffer(), itemOffset, maxLimit, array);
                itemOffset = item.limit();
                Flyweight newItem = ((Flyweight.Builder)this.itemRW).wrap(this).rebuild(item, this.maxLength);
                int newLimit = newItem.limit();
                assert (newLimit <= itemOffset);
                this.limit(newLimit);
            }
            length = this.limit() - this.offset() - 2;
            this.buffer().putShort(this.offset() + 0, (short)length, this.byteOrder);
            Array16FW array16 = (Array16FW)super.build();
            array16.maxLength(this.maxLength);
            return array16;
        }
    }
}

