/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.types.control;

import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.reaktor.internal.types.ArrayFW;
import org.reaktivity.reaktor.internal.types.Flyweight;
import org.reaktivity.reaktor.internal.types.String8FW;

public final class UnresolveFW
extends Flyweight {
    public static final int FIELD_OFFSET_CORRELATION_ID = 0;
    private static final int FIELD_SIZE_CORRELATION_ID = 8;
    public static final int FIELD_OFFSET_NUKLEUS = 8;
    public static final int FIELD_OFFSET_AUTHORIZATION = 0;
    private static final int FIELD_SIZE_AUTHORIZATION = 8;
    public static final int TYPE_ID = 18;
    private final String8FW nukleusRO = new String8FW();

    public long correlationId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    public String8FW nukleus() {
        return this.nukleusRO;
    }

    public long authorization() {
        return this.buffer().getLong(this.nukleusRO.limit() + 0);
    }

    public int typeId() {
        return 18;
    }

    @Override
    public UnresolveFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.nukleusRO.wrap(buffer, offset + 8, maxLimit);
        UnresolveFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public UnresolveFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.nukleusRO.tryWrap(buffer, offset + 8, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.nukleusRO.limit() + 0 + 8;
    }

    public String toString() {
        return String.format("UNRESOLVE [correlationId=%d, nukleus=%s, authorization=%d]", this.correlationId(), this.nukleusRO.asString(), this.authorization());
    }

    public static final class Builder
    extends Flyweight.Builder<UnresolveFW> {
        private static final int INDEX_CORRELATION_ID = 0;
        private static final int INDEX_NUKLEUS = 1;
        private static final int INDEX_AUTHORIZATION = 2;
        private static final int FIELD_COUNT = 3;
        private final String8FW.Builder nukleusRW = new String8FW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new UnresolveFW());
        }

        public Builder correlationId(long value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 8;
            UnresolveFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        private String8FW.Builder nukleus() {
            assert (this.lastFieldSet == 0);
            return this.nukleusRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder nukleus(String value) {
            String8FW.Builder nukleusRW = this.nukleus();
            nukleusRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 1;
            this.limit(nukleusRW.build().limit());
            return this;
        }

        public Builder nukleus(String8FW value) {
            String8FW.Builder nukleusRW = this.nukleus();
            nukleusRW.set(value);
            this.lastFieldSet = 1;
            this.limit(nukleusRW.build().limit());
            return this;
        }

        public Builder nukleus(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder nukleusRW = this.nukleus();
            nukleusRW.set(buffer, offset, length);
            this.lastFieldSet = 1;
            this.limit(nukleusRW.build().limit());
            return this;
        }

        public Builder authorization(long value) {
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + 8;
            UnresolveFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 2;
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<UnresolveFW>, ? extends Flyweight.Builder<UnresolveFW>, UnresolveFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public UnresolveFW build() {
            assert (this.lastFieldSet == 2);
            this.lastFieldSet = -1;
            return (UnresolveFW)super.build();
        }
    }
}

