/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.test.internal.k3po.ext.behavior;

import java.util.Deque;
import java.util.LinkedList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelConfig;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.ServerChannel;
import org.kaazing.k3po.driver.internal.netty.bootstrap.channel.AbstractChannel;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;
import org.reaktivity.reaktor.internal.budget.DefaultBudgetCreditor;
import org.reaktivity.reaktor.internal.budget.DefaultBudgetDebitor;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.DefaultNukleusChannelConfig;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusByteOrder;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusChannelAddress;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusChannelConfig;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusExtensionKind;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusReaktor;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusServerChannel;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusThrottleMode;
import org.reaktivity.reaktor.test.internal.k3po.ext.types.control.Capability;

public abstract class NukleusChannel
extends AbstractChannel<NukleusChannelConfig> {
    static final ChannelBufferFactory NATIVE_BUFFER_FACTORY = NukleusByteOrder.NATIVE.toBufferFactory();
    private long routeId;
    private long writableSeq;
    private long writableAck;
    private long writableAckCheckpoint = -1L;
    private int writablePadding;
    private int writableMin;
    private int writableMax;
    private long readableSeq;
    private long readableAck;
    private long sourceId;
    private long sourceAuth;
    private long targetId;
    private long targetAuth;
    final NukleusReaktor reaktor;
    final Deque<MessageEvent> writeRequests;
    private NukleusExtensionKind readExtKind;
    private ChannelBuffer readExtBuffer;
    private NukleusExtensionKind writeExtKind;
    private ChannelBuffer writeExtBuffer;
    private boolean targetWriteRequestInProgress;
    private ChannelFuture beginOutputFuture;
    private ChannelFuture beginInputFuture;
    private int capabilities;
    private boolean flushable;
    private DefaultBudgetDebitor debitor;
    private long debitorIndex = -1L;
    private DefaultBudgetCreditor creditor;
    private long creditorIndex = -1L;
    private long debitorId;
    private long creditorId;
    private int pendingSharedBudget;
    private int readFlags = -1;
    private int writeFlags = -1;

    NukleusChannel(NukleusServerChannel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, NukleusReaktor reaktor, long targetId) {
        super((ServerChannel)parent, factory, pipeline, sink, (ChannelConfig)new DefaultNukleusChannelConfig());
        this.reaktor = reaktor;
        this.writeRequests = new LinkedList<MessageEvent>();
        this.routeId = -1L;
        this.targetId = targetId;
    }

    public NukleusChannelAddress getLocalAddress() {
        return (NukleusChannelAddress)super.getLocalAddress();
    }

    public NukleusChannelAddress getRemoteAddress() {
        return (NukleusChannelAddress)super.getRemoteAddress();
    }

    public int getLocalScope() {
        return 63;
    }

    public abstract int getRemoteScope();

    protected void setBound() {
        super.setBound();
    }

    protected void setConnected() {
        super.setConnected();
    }

    protected boolean isReadAborted() {
        return super.isReadAborted();
    }

    protected boolean isWriteAborted() {
        return super.isWriteAborted();
    }

    protected boolean isReadClosed() {
        return super.isReadClosed();
    }

    protected boolean isWriteClosed() {
        return super.isWriteClosed();
    }

    protected boolean setReadClosed() {
        return super.setReadClosed();
    }

    protected boolean setWriteClosed() {
        return super.setWriteClosed();
    }

    protected boolean setReadAborted() {
        return super.setReadAborted();
    }

    protected boolean setWriteAborted() {
        return super.setWriteAborted();
    }

    protected boolean setClosed() {
        return super.setClosed();
    }

    protected void setRemoteAddress(ChannelAddress remoteAddress) {
        super.setRemoteAddress(remoteAddress);
    }

    protected void setLocalAddress(ChannelAddress localAddress) {
        super.setLocalAddress(localAddress);
    }

    public String toString() {
        NukleusChannelAddress localAddress = this.getLocalAddress();
        String description = localAddress != null ? localAddress.toString() : super.toString();
        return String.format("%s [sourceId=%d, targetId=%d]", description, this.sourceId, this.targetId);
    }

    public void acknowledgeBytes(int reserved) {
        this.readableAck += (long)reserved;
        assert (this.readableAck <= this.readableSeq);
    }

    public int readableBudget() {
        int readableMax = this.sourceMax();
        return Math.max(readableMax - (int)Math.max(this.readableSeq - this.readableAck, 0L), 0);
    }

    public void routeId(long routeId) {
        this.routeId = routeId;
    }

    public long routeId() {
        return this.routeId;
    }

    public void sourceId(long sourceId) {
        this.sourceId = sourceId;
    }

    public long sourceId() {
        return this.sourceId;
    }

    public long targetId() {
        return this.targetId;
    }

    public void sourceAuth(long sourceAuth) {
        this.sourceAuth = sourceAuth;
    }

    public long sourceAuth() {
        return this.sourceAuth;
    }

    public void targetAuth(long targetAuth) {
        this.targetAuth = targetAuth;
    }

    public long targetAuth() {
        return this.targetAuth;
    }

    public long sourceSeq() {
        return this.readableSeq;
    }

    public void sourceSeq(long readableSeq) {
        assert (readableSeq >= this.readableSeq);
        this.readableSeq = readableSeq;
    }

    public long sourceAck() {
        return this.readableAck;
    }

    public void sourceAck(long readableAck) {
        assert (readableAck >= this.readableAck);
        this.readableAck = readableAck;
    }

    public int sourceMax() {
        return ((NukleusChannelConfig)this.getConfig()).getWindow();
    }

    public ChannelFuture beginOutputFuture() {
        if (this.beginOutputFuture == null) {
            this.beginOutputFuture = Channels.future((Channel)this);
        }
        return this.beginOutputFuture;
    }

    public ChannelFuture beginInputFuture() {
        if (this.beginInputFuture == null) {
            this.beginInputFuture = Channels.future((Channel)this);
        }
        return this.beginInputFuture;
    }

    public void setCreditor(DefaultBudgetCreditor creditor, long creditorId) {
        assert (this.creditor == null);
        this.creditor = creditor;
        this.creditorId = creditorId;
    }

    public void setCreditorIndex(long creditorIndex) {
        assert (creditorIndex != -1L);
        this.creditorIndex = creditorIndex;
        this.getCloseFuture().addListener(this::cleanupCreditor);
    }

    public void doSharedCredit(long traceId, int credit) {
        if (this.creditor != null && this.creditorId != 0L) {
            this.creditor.creditById(traceId, this.creditorId, (long)credit);
        }
    }

    public int pendingSharedBudget() {
        return this.pendingSharedBudget;
    }

    public void pendingSharedCredit(int pendingSharedCredit) {
        if (this.creditorId != 0L) {
            this.pendingSharedBudget += pendingSharedCredit;
        }
    }

    public int readFlags() {
        return this.readFlags;
    }

    public void readFlags(int readFlags) {
        this.readFlags = readFlags;
    }

    public int writeFlags() {
        return this.writeFlags;
    }

    public void writeFlags(int flags) {
        this.writeFlags = flags;
    }

    public void setDebitor(DefaultBudgetDebitor debitor, long debitorId) {
        assert (this.debitor == null);
        this.debitor = debitor;
        this.debitorId = debitorId;
        this.debitorIndex = debitor.acquire(debitorId, this.targetId, this::systemFlush);
        if (this.debitorIndex == -1L) {
            this.getCloseFuture().setFailure((Throwable)new ChannelException("Unable to acquire debitor"));
        } else {
            assert (this.debitorIndex != -1L);
            this.getCloseFuture().addListener(this::cleanupDebitor);
        }
    }

    public boolean hasDebitor() {
        return this.debitor != null;
    }

    public long debitorId() {
        return this.debitorId;
    }

    public long creditorId() {
        return this.creditorId;
    }

    private void systemFlush(long budgetId) {
        ChannelFuture flushFuture = Channels.future((Channel)this);
        this.reaktor.systemFlush(this, flushFuture);
    }

    public int writableBytes() {
        return Math.max(this.writableBudget() - this.writablePadding, 0);
    }

    private int writableBudget() {
        return this.writableMax - (int)Math.max(this.writableSeq - this.writableAck, 0L);
    }

    public boolean writable() {
        int writableBudget = this.writableBudget();
        if (this.debitor != null && this.debitorIndex != -1L) {
            writableBudget = Math.min(writableBudget, (int)this.debitor.available(this.debitorIndex));
        }
        return writableBudget > this.writablePadding || !((NukleusChannelConfig)this.getConfig()).hasThrottle();
    }

    public int paddedBytes(int unpaddedBytes) {
        return unpaddedBytes + ((NukleusChannelConfig)this.getConfig()).getPadding();
    }

    public int reservedBytes(int writableBytes) {
        int reservedBytes = Math.max(writableBytes + this.writablePadding, this.writableMin);
        boolean hasThrottle = ((NukleusChannelConfig)this.getConfig()).hasThrottle();
        if (hasThrottle && (reservedBytes = Math.max((writableBytes = Math.min(this.writableBytes(), writableBytes)) + this.writablePadding, this.writableMin)) > 0 && this.debitor != null && this.debitorIndex != -1L) {
            reservedBytes = this.debitor.claim(this.debitorIndex, this.targetId, reservedBytes, reservedBytes);
        }
        return reservedBytes;
    }

    public void readBytes(long sequence, int reservedBytes) {
        int readableMax = this.sourceMax();
        this.readableSeq = sequence + (long)reservedBytes;
        assert (this.readableSeq <= this.readableAck + (long)readableMax);
    }

    public void writtenBytes(int writtenBytes, int reservedBytes) {
        assert (reservedBytes >= 0);
        this.writableSeq += (long)reservedBytes;
        assert (this.writableSeq >= this.writableAck);
        assert (!(this.writablePadding < 0 || this.writableSeq > this.writableAck + (long)this.writableMax && ((NukleusChannelConfig)this.getConfig()).hasThrottle()));
    }

    public long targetSeq() {
        return this.writableSeq;
    }

    public long targetAck() {
        return this.writableAck;
    }

    public void targetAck(long writableAck) {
        assert (writableAck >= this.writableAck);
        this.writableAck = writableAck;
        assert (writableAck <= this.writableSeq);
    }

    public int targetPad() {
        return this.writablePadding;
    }

    public int targetMax() {
        return this.writableMax;
    }

    public int targetMin() {
        return this.writableMin;
    }

    public void writableWindow(long acknowledge, int padding, int minimum, int maximum, long traceId) {
        this.writableAck = acknowledge;
        this.writablePadding = padding;
        this.writableMin = minimum;
        this.writableMax = maximum;
        assert (this.writableAck <= this.writableSeq);
        if (((NukleusChannelConfig)this.getConfig()).getThrottle() == NukleusThrottleMode.MESSAGE && this.targetWriteRequestInProgress && this.writableAck >= this.writableAckCheckpoint) {
            this.completeWriteRequestIfFullyWritten();
        }
    }

    public void capabilities(int capabilities) {
        this.capabilities = capabilities;
    }

    public boolean hasCapability(Capability capability) {
        return (this.capabilities & 1 << capability.ordinal()) != 0;
    }

    public void targetWriteRequestProgressing() {
        if (((NukleusChannelConfig)this.getConfig()).getThrottle() == NukleusThrottleMode.MESSAGE) {
            MessageEvent writeRequest = this.writeRequests.peekFirst();
            ChannelBuffer message = (ChannelBuffer)writeRequest.getMessage();
            this.writableAckCheckpoint = this.writableSeq + (long)message.readableBytes();
            this.targetWriteRequestInProgress = true;
        }
    }

    public ChannelBuffer writeExtBuffer(NukleusExtensionKind writeExtKind, boolean readonly) {
        if (this.writeExtKind != writeExtKind) {
            if (readonly) {
                return ChannelBuffers.EMPTY_BUFFER;
            }
            if (this.writeExtBuffer == null) {
                this.writeExtBuffer = ((NukleusChannelConfig)this.getConfig()).getBufferFactory().getBuffer(8192);
            } else {
                this.writeExtBuffer.clear();
            }
            this.writeExtKind = writeExtKind;
        }
        return this.writeExtBuffer;
    }

    public ChannelBuffer readExtBuffer(NukleusExtensionKind readExtKind) {
        if (this.readExtKind != readExtKind) {
            if (this.readExtBuffer == null) {
                this.readExtBuffer = ((NukleusChannelConfig)this.getConfig()).getBufferFactory().getBuffer(8192);
            } else {
                this.readExtBuffer.clear();
            }
            this.readExtKind = readExtKind;
        }
        return this.readExtBuffer;
    }

    public void targetWriteRequestProgress() {
        switch (((NukleusChannelConfig)this.getConfig()).getThrottle()) {
            case MESSAGE: {
                if (!this.targetWriteRequestInProgress || this.writableAck < this.writableAckCheckpoint) break;
                this.completeWriteRequestIfFullyWritten();
                break;
            }
            default: {
                this.completeWriteRequestIfFullyWritten();
            }
        }
    }

    public boolean isTargetWriteRequestInProgress() {
        return this.targetWriteRequestInProgress;
    }

    public void setFlushable() {
        this.flushable = true;
    }

    public boolean isFlushable() {
        return this.flushable;
    }

    private void cleanupCreditor(ChannelFuture future) throws Exception {
        assert (this.creditorIndex != -1L);
        this.creditor.release(this.creditorIndex);
        this.creditorIndex = -1L;
    }

    private void cleanupDebitor(ChannelFuture future) throws Exception {
        assert (this.debitorIndex != -1L);
        this.debitor.release(this.debitorIndex, this.targetId);
        this.debitorIndex = -1L;
        this.debitorId = 0L;
    }

    private void completeWriteRequestIfFullyWritten() {
        MessageEvent writeRequest = this.writeRequests.peekFirst();
        ChannelBuffer message = (ChannelBuffer)writeRequest.getMessage();
        if (!message.readable()) {
            this.targetWriteRequestInProgress = false;
            this.writeRequests.removeFirst();
            writeRequest.getFuture().setSuccess();
        }
    }
}

