/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.test.internal.k3po.ext.types;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.reaktor.test.internal.k3po.ext.types.ArrayFW;

public abstract class Flyweight {
    private static byte[] EMPTY_BYTES = new byte[0];
    private DirectBuffer buffer;
    private int offset;
    private int maxLimit;
    private UnsafeBuffer compareBuffer = new UnsafeBuffer(EMPTY_BYTES);

    public final int offset() {
        return this.offset;
    }

    public final DirectBuffer buffer() {
        return this.buffer;
    }

    public abstract int limit();

    public final int sizeof() {
        return this.limit() - this.offset();
    }

    protected final int maxLimit() {
        return this.maxLimit;
    }

    public Flyweight tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (offset > maxLimit) {
            return null;
        }
        this.buffer = buffer;
        this.offset = offset;
        this.maxLimit = maxLimit;
        return this;
    }

    public Flyweight wrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (offset > maxLimit) {
            String msg = String.format("offset=%d is beyond maxLimit=%d", offset, maxLimit);
            throw new IndexOutOfBoundsException(msg);
        }
        this.buffer = buffer;
        this.offset = offset;
        this.maxLimit = maxLimit;
        return this;
    }

    public Flyweight wrap(DirectBuffer buffer, int offset, int maxLimit, ArrayFW<?> array) {
        this.wrap(buffer, offset, maxLimit);
        return this;
    }

    protected static final void checkLimit(int limit, int maxLimit) {
        if (limit > maxLimit) {
            String msg = String.format("limit=%d is beyond maxLimit=%d", limit, maxLimit);
            throw new IndexOutOfBoundsException(msg);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Flyweight)) {
            return false;
        }
        Flyweight that = (Flyweight)obj;
        this.compareBuffer.wrap(this.buffer, this.offset, this.sizeof());
        that.compareBuffer.wrap(that.buffer, that.offset, that.sizeof());
        return this.compareBuffer.equals((Object)that.compareBuffer);
    }

    public int hashCode() {
        int result = 1;
        for (int i = this.offset; i < this.limit(); ++i) {
            result = 31 * result + this.buffer.getByte(i);
        }
        return result;
    }

    public static abstract class Builder<T extends Flyweight> {
        private final T flyweight;
        private MutableDirectBuffer buffer;
        private int offset;
        private int limit;
        private int maxLimit;

        protected Builder(T flyweight) {
            this.flyweight = flyweight;
        }

        public final int limit() {
            return this.limit;
        }

        public final int maxLimit() {
            return this.maxLimit;
        }

        public T build() {
            ((Flyweight)this.flyweight).wrap((DirectBuffer)this.buffer, this.offset, this.limit);
            return this.flyweight;
        }

        public void reset(ArrayFW.Builder<?, ?, ?> array) {
        }

        public Builder<T> rewrap() {
            this.limit = this.offset;
            return this;
        }

        public final T flyweight() {
            return this.flyweight;
        }

        public final MutableDirectBuffer buffer() {
            return this.buffer;
        }

        protected final int offset() {
            return this.offset;
        }

        public int sizeof() {
            return this.limit - this.offset;
        }

        protected final void limit(int limit) {
            this.limit = limit;
        }

        public Builder<T> wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            this.buffer = buffer;
            this.offset = offset;
            this.limit = offset;
            this.maxLimit = maxLimit;
            return this;
        }

        public Builder<T> wrap(ArrayFW.Builder<?, ?, ?> array) {
            this.buffer = array.buffer();
            this.offset = array.limit();
            this.limit = array.limit();
            this.maxLimit = array.maxLimit();
            return this;
        }

        public <E> Builder<T> iterate(Iterable<E> iterable, Consumer<E> action) {
            iterable.forEach(action);
            return this;
        }

        public T rebuild(T item, int maxLength) {
            return item;
        }

        public Builder<T> set(T value) {
            this.buffer().putBytes(this.offset(), ((Flyweight)value).buffer(), ((Flyweight)value).offset(), ((Flyweight)value).sizeof());
            this.limit(this.limit() + ((Flyweight)value).sizeof());
            return this;
        }

        @FunctionalInterface
        public static interface Visitor {
            public int visit(MutableDirectBuffer var1, int var2, int var3);
        }
    }

    @FunctionalInterface
    public static interface Visitor<T> {
        public T visit(DirectBuffer var1, int var2, int var3);
    }
}

